<?php

namespace WTS_EAE\Modules\EvergreenTimer\Skins;

use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

class Skin_1 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-evergreen-timer/skin1_general_style/before_section_end', [
			$this,'extra_controls_add'
		] );
	}

	public function get_id() {
		return 'skin1';
	}

	public function get_title() {
		return __( 'Skin 1', 'wts-eae' );
	}

	function extra_controls_add(){
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'box_border',
				'label'       => __( 'Border', 'wts-eae' ),
				'selector'    =>
					'{{WRAPPER}} .eae-time-wrapper',
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label'      => __( 'Border Radius', 'wts-eae' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .eae-time-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	}
	function render(){
	    $data = $this->parent->get_data();
		$settings = $this->parent->get_settings_for_display();
	    //print_r($data);
		$actions = $this->eae_get_egt_actions($settings);
        if($settings['action_after_expire'] !== ''){
            $this->parent->add_render_attribute( 'wrapper', 'data-actions', json_encode($settings['action_after_expire']) );
	        if($settings['redirect_url_expire'] !== ''){
		        $this->parent->add_render_attribute( 'wrapper', 'data-redirected-url', $settings['redirect_url_expire'] );
	        }
        }
        else{
	        $this->parent->add_render_attribute( 'wrapper', 'data-actions', '[""]' );
        }

		$cookie_temp_name = "eae-temp-". $data['id'];
		$cookie_name = "eae-temp-". $data['id'];
        $show_data = 'show';
		if(isset($_COOKIE[$cookie_temp_name])) {
            //echo 'cookie set';
            //echo 'cookie value'. $_COOKIE[$cookie_temp_name];
		}
        else {
	        //echo 'cookie not set';

	        $this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-expire' );

	        if ( ! Plugin::instance()->editor->is_edit_mode() ) {
		        if($settings['action_after_expire'] !== ''){
		            foreach ( $actions as $index => $item ) :
			            if ( $item['type'] == 'redirect' || $item['type'] == 'hide_parent' || $item['type'] == 'hide' ) {
				            $show_data = 'hide';
			            }
		            endforeach;
                }
	        }
        }
		//$countDownDate = $this->get_egt_interval($settings);
        //echo 'countdowndate '. $countDownDate;

		$unqId = 'eae-egt-'.rand();
		$this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-wrapper' );
		$this->parent->add_render_attribute( 'wrapper', 'class', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-id', $data['id'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-unqid', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-element-type', $settings['countdown_type'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-egtime', $this->get_egt_interval($settings) );
		$this->parent->add_render_attribute( 'wrapper', 'data-egt-expire', $settings['egt_expiry'] );

		$this->parent->add_render_attribute( 'wrapper_days', 'class', 'eae-time-wrapper' );
		if($settings['show_days'] !== 'yes'){
			$this->parent->add_render_attribute( 'wrapper_days', 'class', 'eae-egt-hide' );
        }
		$this->parent->add_render_attribute( 'wrapper_hours', 'class', 'eae-time-wrapper' );
		if($settings['show_hours'] !== 'yes'){
			$this->parent->add_render_attribute( 'wrapper_hours', 'class', 'eae-egt-hide' );
		}
		$this->parent->add_render_attribute( 'wrapper_minutes', 'class', 'eae-time-wrapper' );
		if($settings['show_minutes'] !== 'yes'){
			$this->parent->add_render_attribute( 'wrapper_minutes', 'class', 'eae-egt-hide' );
		}
		$this->parent->add_render_attribute( 'wrapper_seconds', 'class', 'eae-time-wrapper' );
		if($settings['show_seconds'] !== 'yes'){
			$this->parent->add_render_attribute( 'wrapper_seconds', 'class', 'eae-egt-hide' );
		}
		?>

		<div <?php echo $this->parent->get_render_attribute_string( 'wrapper' ); ?>>

			<?php if($show_data === 'show') {
			    ?>
                <h2 class="egt-title"><?php echo $settings['countdown_title'] ?></h2>
            <div id="eaeclockdiv">
				<div <?php echo $this->parent->get_render_attribute_string( 'wrapper_days' ); ?>>
					<span id="eaedivDays" class="egt-time egt-days"></span>
					<div class="egt-time-text smalltext">Days</div>
				</div>
                <div <?php echo $this->parent->get_render_attribute_string( 'wrapper_hours' ); ?>>
					<span id="eaedivHours" class="egt-time egt-hours"></span>
					<div class="egt-time-text smalltext">Hours</div>
				</div>
                <div <?php echo $this->parent->get_render_attribute_string( 'wrapper_minutes' ); ?>>
					<span id="eaedivMinutes" class="egt-time egt-minutes"></span>
					<div class="egt-time-text smalltext">Minutes</div>
				</div>
                <div <?php echo $this->parent->get_render_attribute_string( 'wrapper_seconds' ); ?>>
					<span id="eaedivSeconds" class="egt-time egt-seconds"></span>
					<div class="egt-time-text smalltext">Seconds</div>
				</div>
			</div>
			<?php } ?>
            <div class="eae-egt-message">
                <?php echo do_shortcode( $settings['expire_message'] ); ?>
            </div>
		</div>
<?php
	}
}