<?php

namespace WTS_EAE\Modules\EvergreenTimer\Skins;

use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

class Skin_3 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-evergreen-timer/skin3_general_style/before_section_end', [
			$this,
			'general_control_add'
		] );
		add_action( 'elementor/element/eae-evergreen-timer/skin3_time_style/before_section_end', [
			$this,
			'extra_controls_add'
		] );
		add_action( 'elementor/element/eae-evergreen-timer/skin3_time_text_style/after_section_end', [
			$this,
			'extra_controls_update'
		] );
	}

	public function get_id() {
		return 'skin3';
	}

	public function get_title() {
		return __( 'Skin 3', 'wts-eae' );
	}

	function extra_controls_update() {
		$this->remove_control( 'wrapper_bg_color' );
		$this->remove_responsive_control( 'wrapper_padding' );
		$this->remove_control( 'time_num_bg_color' );
		$this->remove_control( 'time_text_bg_color' );
		//$this->remove_responsive_control( 'time_num_padding' );
		//$this->remove_responsive_control( 'time_text_padding' );

		$this->update_responsive_control(
			'time_num_padding',
			[
			        'mobile_default' => [
			                'top' => '21',
			                'bottom' => '21',
			                'left' => '21',
			                'right' => '21',
                    ],
				'selectors' => [
					'{{WRAPPER}} .egt-time'      => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					'{{WRAPPER}} .egt-time-text' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->update_control( 'wrapper_align',
			[
				'prefix_class' => 'eae-egt-content-align-',
			]
		);
		$this->update_responsive_control( 'time_text_padding',
			[
				'selectors'  => [
					'{{WRAPPER}} .egt-time-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				]
			]
		);
	}

	function general_control_add() {
			/*$this->add_responsive_control(
				'item_height',
				[
					'label'     => __( 'Height', 'wts-eae' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 150,
						],
					],
					'default'   => [
						'size' => 90,
					],
					'mobile_default'   => [
						'size' => 30,
					],
					'selectors' => [
						'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin3"] #timer' => 'grid-template-rows: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'item_width',
				[
					'label'     => __( 'Width', 'wts-eae' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 200,
							'max' => 1000,
						],
					],
					'default'   => [
						'size' => 768,
					],
					'selectors' => [
						'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin3"] .eae-evergreen-wrapper' => 'max-width: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);*/

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'box_border',
				'label'    => __( 'Border', 'wts-eae' ),
				'selector' =>
					'{{WRAPPER}} #timer span',
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label'      => __( 'Border Radius', 'wts-eae' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}}[data-element_type="eae-evergreen-timer.skin3"] #timer span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	}

	function extra_controls_add() {
		$this->add_control(
			'time_num_bg_color1',
			[
				'label'     => __( 'Background Color Day', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #timer span:nth-child(1)' => 'background-color: {{VALUE}}'
				]
			]
		);
		$this->add_control(
			'time_num_bg_color2',
			[
				'label'     => __( 'Background Color Hour', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #timer span:nth-child(2)' => 'background-color: {{VALUE}}'
				]
			]
		);
		$this->add_control(
			'time_num_bg_color3',
			[
				'label'     => __( 'Background Color Minutes', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #timer span:nth-child(3)' => 'background-color: {{VALUE}}'
				]
			]
		);
		$this->add_control(
			'time_num_bg_color4',
			[
				'label'     => __( 'Background Color Seconds', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #timer span:nth-child(4)' => 'background-color: {{VALUE}}'
				]
			]
		);
	}

	function render() {
		$data     = $this->parent->get_data();
		$settings = $this->parent->get_settings_for_display();
		//print_r($data);
		$actions = $this->eae_get_egt_actions($settings);

		if($settings['action_after_expire'] !== ''){
			$this->parent->add_render_attribute( 'wrapper', 'data-actions', json_encode($settings['action_after_expire']) );
			if($settings['redirect_url_expire'] !== ''){
				$this->parent->add_render_attribute( 'wrapper', 'data-redirected-url', $settings['redirect_url_expire'] );
            }
		}
		else{
			$this->parent->add_render_attribute( 'wrapper', 'data-actions', '[""]' );
		}

		$cookie_temp_name = "eae-temp-". $data['id'];
		$cookie_name = "eae-temp-". $data['id'];
		$show_data = 'show';
		if(isset($_COOKIE[$cookie_temp_name])) {
			//echo 'cookie set';
			//echo 'cookie value'. $_COOKIE[$cookie_temp_name];
		}
		else {
			$this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-expire' );

			if ( ! Plugin::instance()->editor->is_edit_mode() ) {
				if($settings['action_after_expire'] !== ''){
					foreach ( $actions as $index => $item ) :
						if ( $item['type'] == 'redirect' || $item['type'] == 'hide_parent' || $item['type'] == 'hide' ) {
							$show_data = 'hide';
						}
					endforeach;
				}
			}
		}

		$unqId = 'eae-egt-'.rand();
		$this->parent->add_render_attribute( 'wrapper', 'class', 'eae-evergreen-wrapper' );
		$this->parent->add_render_attribute( 'wrapper', 'class', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-unqid', $unqId );
		$this->parent->add_render_attribute( 'wrapper', 'data-id', $data['id'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-element-type', $settings['countdown_type'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-egtime', $this->get_egt_interval( $settings ) );
		$this->parent->add_render_attribute( 'wrapper', 'data-egt-expire', $settings['egt_expiry'] );

		if ( $settings['show_days'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-days', 'yes' );
		}
		if ( $settings['show_hours'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-hours', 'yes' );
		}
		if ( $settings['show_minutes'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-mins', 'yes' );
		}
		if ( $settings['show_seconds'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-seconds', 'yes' );
		}
		?>

        <div <?php echo $this->parent->get_render_attribute_string( 'wrapper' ); ?>>
	        <?php if($show_data === 'show') { ?>
        <h2 class="egt-title"><?php echo $settings['countdown_title'] ?></h2>

            <div id="timer"></div>

            <div class="desc">
				<?php
				if ( $settings['show_days'] == 'yes' ) {
					?>
                    <span class="egt-time-text">Days</span>
				<?php }
				if ( $settings['show_hours'] == 'yes' ) {
					?>
                    <span class="egt-time-text">Hours</span>
				<?php }
				if ( $settings['show_minutes'] == 'yes' ) {
					?>
                    <span class="egt-time-text">Minutes</span>
				<?php }
				if ( $settings['show_seconds'] == 'yes' ) {
					?>
                    <span class="egt-time-text">Seconds</span>
				<?php }
				?>
            </div>
            <?php } ?>
            <div class="eae-egt-message">
				<?php echo do_shortcode( $settings['expire_message'] ); ?>
            </div>
        </div>
		<?php
	}
}