<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Troms
 */

get_header();
?>
<section id="blog-main" class="blog-main archive grid section">
	<div class="container">
		<div class="row">
			<div class="col-12">	
				<div class="blog-main">
					<div class="row">
						<?php if ( have_posts() ) : ?>
							<?php
							/* Start the Loop */
							while ( have_posts() ) :
								the_post();

								/*
								 * Include the Post-Type-specific template for the content.
								 * If you want to override this in a child theme, then include a file
								 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
								 */
								get_template_part( 'template-parts/content', 'archive' );

							endwhile;

							the_posts_navigation();

							else :

								get_template_part( 'template-parts/content', 'none' );

							endif;
							?>
					</div>

					<div class="row">
						<div class="col-12">
							<!-- Start Pagination -->
							<div class="pagination-main">
							<?php if (function_exists("tromas_portfolio_bs_pagination"))
								    {
								        tromas_portfolio_bs_pagination();
								}  ?>
							</div>
							<!--/ End Pagination -->
						</div>
					</div>			
			</div>						
		</div>
	</div>
</section>
<?php
get_footer();
