<?php
/**
* The header for our theme
*
* This is the template that displays all of the <head> section and everything up until <div id="content">
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package Tromas
*/

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="layout">
<!-- Start Header -->
<header id="header" class="header onepage">
	<div class="container">
		<div class="row">
			<div class="col-lg-3 col-12">
				<!-- Logo -->
				<div class="logo">
					<?php
						if(has_custom_logo()):?>
							<?php echo esc_html(the_custom_logo());?>
						<?php else: ?>		
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html(bloginfo('name'));?></a>
						<?php if( get_theme_mod('tromas_sitetag_enable')):?><h5 class="site-description"><?php esc_html(bloginfo('description'));?></h5><?php endif;?>
					<?php endif; ?>
				</div>
				<!--/ End Logo -->
				<div class="mobile-nav"></div>
			</div>
			<div class="col-lg-9 col-12">
				<!-- Header Widget -->
				<div class="header-widget">
					<!-- Single Widget -->
					<?php if ( is_active_sidebar( 'header-widget' ) ) { ?>
					<?php dynamic_sidebar( 'header-widget' );?>
					<?php } ?>
					<!--/ End Single Widget -->
				</div>
				<!--/ End Header Widget -->
			</div>
		</div>
	</div>
	<!-- Header Inner -->
	<div class="header-inner">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="nav-area">
						<!-- Main Menu -->
						<nav class="mainmenu navbar-expand-lg">
							<div class="collapse navbar-collapse">	
								<?php
									if ( has_nav_menu( 'primary' ) ) :
										wp_nav_menu( array(
									    'theme_location'    => 'primary',
									    'depth'             => 10,
									    'container_class'   => 'collapse navbar-collapse',
									    'container_id'      => 'bs-example-navbar-collapse-1',
									    'menu_class'        => 'nav navbar-nav ml-auto',
									    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
				    					'walker'            => new wp_bootstrap_navwalker(),
						            ));
				        		?>
						        <?php else : ?>
		                			<ul class="nav navbar-nav menu">
		                    			<li class="menu-item">
		                   					 <a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?> "> <?php esc_html_e('Add a menu','tromas'); ?></a>
		                				</li>
		            				</ul>

		            			<?php endif; ?>
							</div>
						</nav>
						<!--/ End Main Menu -->
						<!-- Social -->
						<?php if(get_theme_mod( 'tromas_header_social_url_enable' )):?>
							<ul class="social">
								<?php 
									$social_name_arrays = array(
																'fa fa-linkedin'=>'Linkedin',
																'fa fa-facebook'=>'Facebook',
																'fa fa-twitter'=>'Twitter',
																'fa fa-youtube'=>'Youtube',
																'fa fa-behance'=>'Behance'
																);
								?>

								<?php foreach($social_name_arrays as $key=>$social_name):
										?>
										<?php if(get_theme_mod( 'tromas_header_social_url_'.$social_name)):?>
											<li>
												<a href="<?php echo esc_url(get_theme_mod( 'tromas_header_social_url_'.$social_name))?>">
													<i class="<?php echo esc_attr( $key );?>"></i>
												</a>
											</li>
										<?php endif;?>
								<?php endforeach;?>
							</ul>
						<?php endif;?>
						<!--/ End Social -->
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--/ End Header Inner -->
</header>
<!--/ End Header -->

<?php if( is_home() || (!is_front_page())):?>
<!-- Start Breadcrumbs -->
<section class="breadcrumbs">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php
				if ( is_archive() ) {
				the_archive_title( '<h2>', '</h2>' );
				}
				else{
					echo '<h2>';
				echo esc_html( get_the_title() );
				echo '</h2>';
				}?>
				<?php do_action( 'tromas_breadcrumb' );		
				?>
			</div>
		</div>
	</div>
</section>
<!--/ End Breadcrumbs -->
<?php endif;?>