<?php
/*===================================================================
========================Start Slider Area============================
=====================================================================*/
// Section: Slider.
$wp_customize->add_section( 'tromas_frontpage_slider', array(
	'priority'       => 1,
	'panel'          => 'tromas_frontpage_options',
	'title'          => __( 'Slider Section', 'tromas' ),
	'description'    => __( 'Banner Slider', 'tromas' ),
	'capability'     => 'edit_theme_options'
) );

//Slider Enable or disable
$wp_customize->add_setting( 'tromas_slider_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_slider_enable', array(
    'label'                 =>  __( 'Enable  Slider', 'tromas' ),
    'section'               => 'tromas_frontpage_slider',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_slider_enable',
) );

for ($i=1;$i<=4;$i++) {
	$wp_customize->add_setting( 'tromas_slider_page_'.$i, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
	) );


	$wp_customize->add_control( 'tromas_slider_page_'.$i, array(
		/* translators: %s: Description */ 
	    'label'                 =>  sprintf( __( 'Select Page for Slider %s', 'tromas' ), $i ),
	    'section'               => 'tromas_frontpage_slider',
	    'type'                  => 'dropdown-pages',
	    'settings'              => 'tromas_slider_page_'.$i,
	) );

	$wp_customize->add_setting('tromas_slider_text_position'.$i, 
		array(
			'sanitize_callback'	=> 'tromas_sanitize_select',
			'default'			=> ''
		)
	);

	$wp_customize->add_control('tromas_slider_text_position'.$i, 
		array(
			/* translators: %s: Description */ 
	    	'label'                 =>  sprintf( __( 'Slider %s Text Position', 'tromas' ), $i ),
			'description'		=> esc_html__( 'Select Slider Text Postion right and left', 'tromas' ),
			'section'    		=> 'tromas_frontpage_slider',
			'type'       		=> 'radio',
			'choices'    		=> array(
				'right'   		=> esc_html__('right','tromas'),
				'left'	 		=> esc_html__('left','tromas'),
			),
		) 
	);

	$wp_customize->add_setting( 'tromas_slider_button_title_'.$i, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'tromas_slider_button_title_'.$i, array(
		/* translators: %s: Description */ 
	    'label'                 =>  sprintf( __( 'First Button Title For Slider %s', 'tromas' ), $i ),
	    'description'           =>  __( 'Hire Me', 'tromas' ),
	    'section'               => 'tromas_frontpage_slider',
	    'type'                  => 'text',
	    'settings' => 'tromas_slider_button_title_'.$i,
	) );

	$wp_customize->add_setting( 'tromas_slider_button_url_'.$i, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'esc_url_raw'
	) );
 
	$wp_customize->add_control( 'tromas_slider_button_url_'.$i, array(
		/* translators: %s: Description */ 
	    'label'                 =>  sprintf( __( 'Select URL For button of slider  %s', 'tromas' ), $i ),
	    'description'           =>  __( '#', 'tromas' ),
	    'section'               => 'tromas_frontpage_slider',
	    'type'                  => 'url',
	    'settings' => 'tromas_slider_button_url_'.$i,
	) );
}

/*===================================================================
========================End Slider Area==============================
=====================================================================*/


/*===================================================================
========================Start Features===============================
=====================================================================*/

// Section: Features.
$wp_customize->add_section( 'tromas_feature', array(
	'priority'       => 2,
	'panel'          => 'tromas_frontpage_options',
	'title'          => __( 'Features Section', 'tromas' ),
	'capability'     => 'edit_theme_options'
) );

//Feaure Enable or disable
$wp_customize->add_setting( 'tromas_feature_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_feature_enable', array(
    'label'                 =>  __( 'Enable  Features', 'tromas' ),
    'section'               => 'tromas_feature',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_feature_enable',
) );

// Pages and icon for Feature section
$feature_icon_examples = array('1'=>'fa-meetup','2'=>'fa-code','3'=>'fa-sellsy');
foreach($feature_icon_examples as $key=>$feature_icon){
	$wp_customize->add_setting( 'tromas_feature_page_'.$key, array(
		    'capability'            => 'edit_theme_options',
		    'default'               => '',
		    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
		) );

	$wp_customize->add_control( 'tromas_feature_page_'.$key, array(
		/* translators: %s: Description */ 
	    'label'                 =>  sprintf( __( 'Select Page for Feature %s', 'tromas' ), $key ),
	    'section'               => 'tromas_feature',
	    'type'                  => 'dropdown-pages',
	    'settings'              => 'tromas_feature_page_'.$key,
	) );

	$wp_customize->add_setting( 'tromas_feature_icon_page_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'tromas_feature_icon_page_'.$key, array(
		/* translators: %s: Label */ 
	    'label'                 =>   sprintf( __( 'Icon For Feature %s', 'tromas' ), $key ),
	    /* translators: %s: Description */ 
	    'description'           => sprintf( __( 'Use font awesome icon: Eg:%1$s. %2$s See more here %3$s', 'tromas' ), $feature_icon,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
	    'section'               => 'tromas_feature',
	    'type'                  => 'text',
	    'settings' => 'tromas_feature_icon_page_'.$key,
	) );
}

/*===================================================================
========================End Features=================================
=====================================================================*/

/*=====================================================================
========================Start About Us=================================
=======================================================================*/
$wp_customize->add_section( 'tromas_about_us_section', array(
	'priority'       => 3,
	'panel'          => 'tromas_frontpage_options',
	'title'          => __( 'Front About Section', 'tromas' ),
	'description'   => __( 'Select pages for About section, you can also change the icon per page', 'tromas' ),
	'capability'     => 'edit_theme_options'
) );

//About section enable disable
$wp_customize->add_setting( 'tromas_about_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_about_section_enable', array(
    'label'                 =>  __( 'Enable  About section', 'tromas' ),
    'section'               => 'tromas_about_us_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_about_section_enable',
) );

//About tab title and icon
$about_icon_examples =array('1'=>'fa-user','2'=>'fa-pencil','3'=>'fa-photo','4'=>'fa-rocket'); 
foreach ($about_icon_examples as $key => $about_icon) {

	$wp_customize->add_setting( 'tromas_about_page_title_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
	) );

	$wp_customize->add_control( 'tromas_about_page_title_'.$key, array(
		/* translators: %s: Label */ 
		'label'                 =>   sprintf( __( 'Select Page for Tab %s Title & Short Description with Featured Image if need', 'tromas' ), $key ),
	    'section'               => 'tromas_about_us_section',
	    'type'                  => 'dropdown-pages',
	    'settings'              => 'tromas_about_page_title_'.$key,
	) );

	$wp_customize->add_setting( 'tromas_about_icon_title_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'tromas_about_icon_title_'.$key, array(
		/* translators: %s: label */ 
	   'label' 	=>   sprintf( __( 'Icon For Tab %s', 'tromas' ), $key ),
	   /* translators: %s: Description */ 
	    'description'           => sprintf( __( 'Use font awesome icon: Eg:%1$s. %2$s See more here %3$s', 'tromas' ), $about_icon,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
	    'section' => 'tromas_about_us_section',
	    'type'    => 'text',
	    'settings'=> 'tromas_about_icon_title_'.$key,
	) ); 

	$wp_customize->add_setting( 'tromas_about_vedio_title_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'tromas_about_vedio_title_'.$key, array(
		/* translators: %s: label */ 
	   'label' 	=>   sprintf( __( 'Vedio For Tab %s', 'tromas' ), $key ),
	   /* translators: %s: Description */ 
	    'description'           => __( 'Use Link from youtube', 'tromas' ),
	    'section' => 'tromas_about_us_section',
	    'type'    => 'url',
	    'settings'=> 'tromas_about_vedio_title_'.$key,
	) ); 
}
/*=====================================================================
========================End About Us=================================
=======================================================================*/

/*=====================================================================
========================Start Our Skill=================================
=======================================================================*/
$wp_customize->add_section( 'tromas_our_skill_section', array(
	'priority'       => 4,
	'panel'          => 'tromas_frontpage_options',
	'title'          => __( 'Front Our Skill Section', 'tromas' ),
	'description'   => __( 'Select pages for Our Skill section', 'tromas' ),
	'capability'     => 'edit_theme_options'
) );

//About section enable disable
$wp_customize->add_setting( 'tromas_our_skill_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_our_skill_section_enable', array(
    'label'                 =>  __( 'Enable our skill section', 'tromas' ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_our_skill_section_enable',
) );


//Our Skill page tile and content
$wp_customize->add_setting( 'tromas_skill_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_skill_title', array(
    'label'                 =>  __( 'Select Page for Heading and description', 'tromas' ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_skill_title',
) );

// Our skill How we work
$wp_customize->add_setting( 'tromas_skill_work_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_skill_work_title', array(
    'label'                 =>  __( 'Select Page left section Heading and description', 'tromas' ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_skill_work_title',
) );

//Our Skill button title and url
 $wp_customize->add_setting( 'tromas_skill_button_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_skill_button_title', array(
    /* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Skill button  %s', 'tromas' ), 'title' ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'text',
    'settings' => 'tromas_skill_button_title',
) );

$wp_customize->add_setting( 'tromas_skill_button_url', array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'esc_url_raw'
) );
 
$wp_customize->add_control( 'tromas_skill_button_url', array(
	/* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Select URL For button of skill  %s', 'tromas' ), 'name' ),
    'description'           =>  __( '#', 'tromas' ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'url',
    'settings' => 'tromas_skill_button_url',
) );
// Our Skill Categories and skill percentage in progress bar
for($i=1;$i<=4;$i++){
    $wp_customize->add_setting( 'tromas_skill_title_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_skill_title_'.$i, array(
    /* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Skill Title  %s', 'tromas' ), $i ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'text',
    'settings' => 'tromas_skill_title_'.$i,
) );

 $wp_customize->add_setting( 'tromas_skill_percentage_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_number_absint'
) );

$wp_customize->add_control( 'tromas_skill_percentage_'.$i, array(
     /* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Skill Percentage  %s', 'tromas' ), $i ),
    'section'               => 'tromas_our_skill_section',
    'type'                  => 'text',
    'settings' => 'tromas_skill_percentage_'.$i,
) );
}
/*==============================================================================
============================Our Skill Customizer End=============================
===============================================================================*/


/*==============================================================================
============================Service Customizer Start============================
===============================================================================*/
$wp_customize->add_section( 'tromas_service_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Service Section', 'tromas' ),
    'description'           => __( 'Select pages for Service section, you can also change the icon per page', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//service section enable disable
$wp_customize->add_setting( 'tromas_service_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_service_section_enable', array(
    'label'                 =>  __( 'Enable Service Section', 'tromas' ),
    'section'               => 'tromas_service_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_service_section_enable',
) );

//service Title
$wp_customize->add_setting( 'tromas_service_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_service_page_title', array(
    'label'                 =>  __( 'Select Page for Service Title and Description', 'tromas' ),
    'section'               => 'tromas_service_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_service_page_title',
) );


// service Us page 1 and Icon 1
$service_array = array('1'=>'fa-edit','2'=>'fa-lightbulb-o','3'=>'fa-money','4'=>'fa-clock-o','5'=>'fa-globe','6'=>'fa-magic');
foreach ($service_array as $key => $service) {

$wp_customize->add_setting( 'tromas_service_page_'.$key, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_service_page_'.$key, array(
   	 /* translators: %s: Label */ 
    'label'                 => sprintf( __( 'Select Page For Service  %1$s', 'tromas' ), $key),
    'section'               => 'tromas_service_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_service_page_'.$key,
) );

$wp_customize->add_setting( 'tromas_service_icon_'.$key, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_service_icon_'.$key, array(
	 /* translators: %s: Label */ 
    'label'                 => sprintf( __( 'Icon For Service  %1$s', 'tromas' ), $key),
    /* translators: %s: Description */ 
    'description'           => sprintf( __( 'Use font awesome icon: Eg: %1$s. %2$s See more here %3$s', 'tromas' ), $service,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
    'section'               => 'tromas_service_section',
    'type'                  => 'text',
    'settings' => 'tromas_service_icon_'.$key,
) );
}

/*==============================================================================
============================Service Customizer End==============================
===============================================================================*/

/*==============================================================================
============================Frequently Asked Question Start=====================
===============================================================================*/
$wp_customize->add_section( 'tromas_faq_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Faq Section', 'tromas' ),
    'description'           => __( 'Select pages for  Frequently Asked Question(Faq) section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//faq section enable disable
$wp_customize->add_setting( 'tromas_faq_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_faq_section_enable', array(
    'label'                 =>  __( 'Enable FAQ Section', 'tromas' ),
    'section'               => 'tromas_faq_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_faq_section_enable',
) );

//faq Title
$wp_customize->add_setting( 'tromas_faq_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_faq_page_title', array(
    'label'                 =>  __( 'Select Page for Faq Title and Description with featured image', 'tromas' ),
    'section'               => 'tromas_faq_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_faq_page_title',
) );

$wp_customize->add_setting('tromas_faq_category_id',array(
	'capability'            => 'edit_theme_options',
	'default' =>  '',
	'sanitize_callback' => 'tromas_sanitize_category',
));
    
$wp_customize->add_control(new tromas_Customize_Dropdown_Taxonomies_Control($wp_customize,'tromas_faq_category_id',
array(
       'label' => __('Select Category for FAQ','tromas'),
        'section' => 'tromas_faq_section',
        'settings' => 'tromas_faq_category_id',
        'type'=> 'dropdown-taxonomies',
    )
));

$wp_customize->add_setting( 'tromas_faq_number', array(
    'capability'            => 'edit_theme_options',
    'default'               => '3',
    'sanitize_callback'     => 'tromas_sanitize_number_absint'
));

$wp_customize->add_control( 'tromas_faq_number', array(
    'label'                 =>  __( 'Number of Recent FAQ to Show in Front Page', 'tromas' ),
    'description'           =>  __( 'input 3,4,5,6,7,8,9,10', 'tromas' ),
    'section'               => 'tromas_faq_section',
    'type'                  => 'text',
    'settings' => 'tromas_faq_number',
) );
/*==
/*==============================================================================
============================Frequently Asked Questions End======================
===============================================================================*/

/*==============================================================================
=================Why Choose(Why choose us) start=======================
===============================================================================*/
$wp_customize->add_section( 'tromas_choose_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Why Choose Section', 'tromas' ),
    'description'           => __( 'Select pages for Why Choose section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//choose section enable disable
$wp_customize->add_setting( 'tromas_choose_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_choose_section_enable', array(
    'label'                 =>  __( 'Enable  Why Choose Section', 'tromas' ),
    'section'               => 'tromas_choose_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_choose_section_enable',
) );

//choose Title
$wp_customize->add_setting( 'tromas_choose_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_choose_page_title', array(
    'label'                 =>  __( 'Select Page for Why choose Title and Description', 'tromas' ),
    'section'               => 'tromas_choose_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_choose_page_title',
) );
//Why Choose Process Button title and url
 $wp_customize->add_setting( 'tromas_choose_button_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_choose_button_title', array(
    /* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Why Choose button  %s', 'tromas' ), 'title' ),
    'section'               => 'tromas_choose_section',
    'type'                  => 'text',
    'settings' => 'tromas_choose_button_title',
) );

$wp_customize->add_setting( 'tromas_choose_button_url', array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'esc_url_raw'
) );
 
$wp_customize->add_control( 'tromas_choose_button_url', array(
	/* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Select URL For button %s', 'tromas' ), 'title' ),
    'description'           =>  __( '#', 'tromas' ),
    'section'               => 'tromas_choose_section',
    'type'                  => 'url',
    'settings' => 'tromas_choose_button_url',
) );
// Why Choose icon title and description
$work_array = array('1'=>'fa-check','2'=>'fa-support','3'=>'fa-optin-monster');
foreach ($work_array as $key => $work) {
$wp_customize->add_setting( 'tromas_choose_page_'.$key, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_choose_page_'.$key, array(
	 /* translators: %s: Label */ 
    'label'                 => sprintf( __( 'Select Page  %1$s For Why Choose', 'tromas' ), $key),
    'section'               => 'tromas_choose_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_choose_page_'.$key,
) );

$wp_customize->add_setting( 'tromas_choose_icon_'.$key, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_choose_icon_'.$key, array(
	 /* translators: %s: Label */ 
    'label'                 => sprintf( __( 'Icon For Why Choose  %1$s', 'tromas' ), $key),
    /* translators: %s: Description */ 
    'description'           => sprintf( __( 'Use font awesome icon: Eg: %1$s. %2$s See more here %3$s', 'tromas' ), $work,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
    'section'               => 'tromas_choose_section',
    'type'                  => 'text',
    'settings' => 'tromas_choose_icon_'.$key,
) );
}

$wp_customize->add_setting( 'tromas_work_video_url', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'esc_url_raw'
) );

$wp_customize->add_control( 'tromas_work_video_url', array(
	/* translators: %s: Label */ 
    'label'                 =>  sprintf( __( 'Select URL For Vedio of slider  %s', 'tromas' ),'Why Choose' ),
    
	'description'           => __( 'Use youtube link', 'tromas' ),
    'section'               => 'tromas_choose_section',
    'type'                  => 'url',
    'settings' => 'tromas_work_video_url',
) );
/*==============================================================================
=================Our working Process(Why choose us) End=======================
===============================================================================*/


/*==============================================================================
=============================Project start=====================================
===============================================================================*/
$wp_customize->add_section( 'tromas_project_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Project Section', 'tromas' ),
    'description'           => __( 'Select pages for Project section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//choose section enable disable
$wp_customize->add_setting( 'tromas_project_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_project_section_enable', array(
    'label'                 =>  __( 'Enable Project Section', 'tromas' ),
    'section'               => 'tromas_project_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_project_section_enable',
) );

//Project Title
$wp_customize->add_setting( 'tromas_project_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_project_page_title', array(
    'label'                 =>  __( 'Select Page for Project Title and Description', 'tromas' ),
    'section'               => 'tromas_project_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_project_page_title',
) );

$wp_customize->add_setting('tromas_project_category_id',array(
	'capability'            => 'edit_theme_options',
	'default' =>  '',
	'sanitize_callback' => 'tromas_sanitize_category',
));
    
$wp_customize->add_control(new tromas_Customize_Dropdown_Taxonomies_Control($wp_customize,'tromas_project_category_id',
array(
       'label' => __('Select Category for Project having subcategories','tromas'),
       'description' => __('Category posts have featured image','tromas'),
        'section' => 'tromas_project_section',
        'settings' => 'tromas_project_category_id',
        'type'=> 'dropdown-taxonomies',
    )
));
/*==============================================================================
=============================Project End========================================
===============================================================================*/

/*==============================================================================
=============================Counter Start=====================================
===============================================================================*/
$wp_customize->add_section( 'tromas_counter_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Counter Section', 'tromas' ),
    'description'           => __( 'Field for Counter section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//Counter section enable disable
$wp_customize->add_setting( 'tromas_counter_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_counter_section_enable', array(
    'label'                 =>  __( 'Enable Counter Section', 'tromas' ),
    'section'               => 'tromas_counter_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_counter_section_enable',
) );
$counter_icon_arrays =  array(
							'1'=>'fa-tasks',
							'2'=>'fa-users',
							'3'=>'fa-coffee',
							'4'=>'fa-trophy'	
							);
foreach($counter_icon_arrays as $key => $counter_icon){
$wp_customize->add_setting( 'tromas_counter_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_counter_'.$key, array(
	/* translators: %s: Description */ 
    'label'                 =>   sprintf( __( 'Type the Number For Counter %s', 'tromas' ), $key ),
    'section'               => 'tromas_counter_section',
    'type'                  => 'text',
    'settings' => 'tromas_counter_'.$key,
) );

$wp_customize->add_setting( 'tromas_counter_field_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_counter_field_'.$key, array(
	/* translators: %s: Description */ 
    'label'                 =>   sprintf( __( 'Type the value For Counter %s', 'tromas' ), $key ),
    'section'               => 'tromas_counter_section',
    'type'                  => 'text',
    'settings' => 'tromas_counter_field_'.$key,
) );

$wp_customize->add_setting( 'tromas_counter_icon_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_counter_icon_'.$key, array(
	/* translators: %s: Label */ 
    'label'                 =>   sprintf( __( 'Icon For Counter %s', 'tromas' ), $key ),
    /* translators: %s: Description */ 
    'description'           => sprintf( __( 'Use font awesome icon: Eg:%1$s. %2$s See more here %3$s', 'tromas' ), $counter_icon,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
    'section'               => 'tromas_counter_section',
    'type'                  => 'text',
    'settings' => 'tromas_counter_icon_'.$key,
) );
}

/*==============================================================================
=============================Counter End========================================
===============================================================================*/

/*==============================================================================
=============================Team Start========================================
===============================================================================*/
$wp_customize->add_section( 'tromas_team_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Team Section', 'tromas' ),
    'description'           => __( 'Select pages for  Team section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Team section enable disable

$wp_customize->add_setting( 'tromas_team_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_team_section_enable', array(
    'label'                 =>  __( 'Enable  Team Section', 'tromas' ),
    'section'               => 'tromas_team_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_team_section_enable',
) );

// Team Title
$wp_customize->add_setting( 'tromas_team_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_team_page_title', array(
    'label'                 =>  __( 'Select Page for  Team Title & Description', 'tromas' ),
    'section'               => 'tromas_team_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_team_page_title',
) );

//  Team Us pages

for ($i=1;$i<5;$i++) {

$wp_customize->add_setting( 'tromas_team_page_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_team_page_'.$i, array(
     /* translators: %s: Description */ 
    'label'                 => sprintf( __( 'Select  Team Page %s', 'tromas' ), $i ),
    'section'               => 'tromas_team_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_team_page_'.$i,
) );

$wp_customize->add_setting( 'tromas_team_position_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_team_position_'.$i, array(
	 /* translators: %s: Label */ 
    'label'                 =>  sprintf( __( 'Select Designation For page %s', 'tromas' ), $i ),
    'description'           =>  __( 'Designation like Creative Director,Web Developer,Server Administor,UI/UX Design', 'tromas' ),
    'section'               => 'tromas_team_section',
    'type'                  => 'text',
    'settings' => 'tromas_team_position_'.$i,
) );
}
/*==============================================================================
=============================Team End========================================
===============================================================================*/

/*==============================================================================
=============================Pricing Table Start================================
===============================================================================*/
$wp_customize->add_section( 'tromas_pricing_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Pricing Section', 'tromas' ),
    'description'           => __( 'Select pages for  Team section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Pricing Table section enable disable

$wp_customize->add_setting( 'tromas_pricing_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_pricing_section_enable', array(
    'label'                 =>  __( 'Enable  Pricing Section', 'tromas' ),
    'section'               => 'tromas_pricing_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_pricing_section_enable',
) );

// Pricing Table Title
$wp_customize->add_setting( 'tromas_pricing_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_pricing_page_title', array(
    'label'                 =>  __( 'Select Page for  Team Title & Description', 'tromas' ),
    'section'               => 'tromas_pricing_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_pricing_page_title',
) );

// Setting: Link of Pricing Table Widget.
class Pricing_Table_Widget_Link extends WP_Customize_Control {
    public $type = 'customtext';
    public $extra = ''; // we add this for the extra description
    public function render_content() {
    ?>
    <label>            
        <a href="<?php echo esc_url( 'widgets.php' ); ?>" target='_blank'><?php echo esc_html( $this->label ); ?></a>
        <span><?php echo esc_html( $this->extra ); ?></span>         
    </label>
    <?php
    }
}
$wp_customize->add_setting('pricing_table_widget_link', array(
  'default' => '',
  'type' => 'customtext',
  'capability' => 'edit_theme_options',
  'transport' => 'refresh',
  'sanitize_callback' => 'sanitize_text_field',
) );
$wp_customize->add_control( new Pricing_Table_Widget_Link( $wp_customize, 'pricing_table_widget_link', array(
    'label' => esc_attr__( 'Go to Widget', 'tromas' ),
    'section' => 'tromas_pricing_section',
    'settings' => 'pricing_table_widget_link',
    'extra' => esc_attr__( ' for more info', 'tromas' )
    ) ) 
);
/*==============================================================================
=============================Pricing Table End==================================
===============================================================================*/


/*==============================================================================
=============================Testimonial Start==================================
===============================================================================*/
$wp_customize->add_section( 'tromas_testimonial_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Testimonials  Section', 'tromas' ),
    'description'           => __( 'Select pages  for Testimonial section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Testimonials section enable disable

$wp_customize->add_setting( 'tromas_testimonial_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_testimonial_section_enable', array(
    'label'                 =>  __( 'Enable  Testimonials Section', 'tromas' ),
    'section'               => 'tromas_testimonial_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_testimonial_section_enable',
) );

// Testimonial page and Designation
for ($i=1;$i<7;$i++) {
$wp_customize->add_setting( 'tromas_testimonial_page_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

 
$wp_customize->add_control( 'tromas_testimonial_page_'.$i, array(
    /* translators: %s: Description */ 
    'label'                 => sprintf( __( 'Select Testimonial Page %s', 'tromas' ), $i ),
    'section'               => 'tromas_testimonial_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_testimonial_page_'.$i,
) );

$wp_customize->add_setting( 'tromas_testimonial_position_'.$i, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );


$wp_customize->add_control( 'tromas_testimonial_position_'.$i, array(
     /* translators: %s: Description */ 
    'label'                 =>  sprintf( __( 'Select Designation or Company Name %s', 'tromas' ), $i ),
    'description'           =>  __( 'Position like Developer, CEO MD', 'tromas' ),
    'section'               => 'tromas_testimonial_section',
    'type'                  => 'text',
    'settings' => 'tromas_testimonial_position_'.$i,
) );
}
/*==============================================================================
=============================Testimonial End==================================
===============================================================================*/

/*==============================================================================
=============================NewsLetter Start==================================
===============================================================================*/
$wp_customize->add_section( 'tromas_newsletter_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Newsletter  Section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Newsletter section enable disable

$wp_customize->add_setting( 'tromas_newsletter_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_newsletter_section_enable', array(
    'label'                 =>  __( 'Enable  Newsletter Section', 'tromas' ),
    'section'               => 'tromas_newsletter_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_newsletter_section_enable',
) );

// Newsletter Form Shortcode Descriptions
$wp_customize->add_setting('tromas_newsletter_shortcode',array(
	'default'       =>      '',
	'sanitize_callback'     =>  'sanitize_text_field'
	));
$wp_customize->add_control('tromas_newsletter_shortcode',array(
	'section'       =>      'tromas_newsletter_section',
	 'label'                 =>  __( 'News Letter Section Use Shortcode', 'tromas' ),
      /* translators: %s: Description */ 
    'description'           => sprintf( __( 'Use Newsletter Plugins shortcode: Eg: %1$s. %2$s See more here %3$s', 'tromas' ), '[newsletter_form]','<a href="'.esc_url('https://wordpress.org/plugins/newsletter/').'" target="_blank">','</a>' ),
	'type'          =>      'text',
	'settings'		=>		'tromas_newsletter_shortcode'
	));
// Newsletter Quotes Description
$wp_customize->add_setting('tromas_newsletter_quote',array(
	'default'       =>      '',
	'sanitize_callback'     =>  'sanitize_text_field'
	));
$wp_customize->add_control('tromas_newsletter_quote',array(
	'section'       =>      'tromas_newsletter_section',
	'label'         =>      __('Newsletter Quote', 'tromas'),
	'type'          =>      'text',
	'settings'		=>		'tromas_newsletter_quote'
	));

/*==============================================================================
=============================NewsLetter End==================================
===============================================================================*/

/*==============================================================================
=============================Client Start=======================================
===============================================================================*/
$wp_customize->add_section( 'tromas_client_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Client  Section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Client section enable disable

$wp_customize->add_setting( 'tromas_client_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_client_section_enable', array(
    'label'                 =>  __( 'Enable  Client Section', 'tromas' ),
    'section'               => 'tromas_client_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_client_section_enable',
) );
// Client Title
$wp_customize->add_setting( 'tromas_client_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_client_page_title', array(
    'label'                 =>  __( 'Select Page for Client Title & Description', 'tromas' ),
    'section'               => 'tromas_client_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_client_page_title',
) );


//Category select for clients
$wp_customize->add_setting('tromas_clients_category_id',array(
'capability'        => 'edit_theme_options',
'sanitize_callback' => 'tromas_sanitize_category',
'default' =>  '1',
   )
);
    
$wp_customize->add_control(new tromas_Customize_Dropdown_Taxonomies_Control($wp_customize,'tromas_clients_category_id',
    array(
               'label' => __('Select Category for Clients','tromas'),
                'section' => 'tromas_client_section',
                'settings' => 'tromas_clients_category_id',
                'type'=> 'dropdown-taxonomies',
        )
));
$wp_customize->add_setting( 'tromas_client_number', array(
    'capability'            => 'edit_theme_options',
    'default'               => '3',
    'sanitize_callback'     => 'tromas_sanitize_number_absint'
));

$wp_customize->add_control( 'tromas_client_number', array(
    'label'                 =>  __( 'Number of Recent Clients to Show in Front Page', 'tromas' ),
    'description'           =>  __( 'input 3,4,5,6,7,8,9,10', 'tromas' ),
    'section'               => 'tromas_client_section',
    'type'                  => 'text',
    'settings' => 'tromas_client_number',
) );
/*==============================================================================
=============================Client End=========================================
===============================================================================*/

/*==============================================================================
=============================Latest Blog Start==================================
===============================================================================*/
$wp_customize->add_section( 'tromas_blog_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front  Blog  Section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

// Blog section enable disable
$wp_customize->add_setting( 'tromas_blog_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_blog_section_enable', array(
    'label'                 =>  __( 'Enable  Blog Section', 'tromas' ),
    'section'               => 'tromas_blog_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_blog_section_enable',
) );
// Blog Title
$wp_customize->add_setting( 'tromas_blog_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_blog_page_title', array(
    'label'                 =>  __( 'Select Page for Blog Title & Description', 'tromas' ),
    'section'               => 'tromas_blog_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_blog_page_title',
) );

// Blog Features Post
$wp_customize->add_setting( 'tromas_blog_feature_post_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );


$wp_customize->add_control(new tromas_Post_Dropdown_Custom_Control($wp_customize,'tromas_blog_feature_post_title',
    array(
           'label' => __('Select Post for Blog Feature','tromas'),
            'section' => 'tromas_blog_section',
            'type'=> 'dropdown-posts',
            'settings' => 'tromas_blog_feature_post_title'
        )
));
//Category select for blogs
$wp_customize->add_setting('tromas_blog_category_id',array(
'capability'        => 'edit_theme_options',
'sanitize_callback' => 'tromas_sanitize_category',
'default' =>  '1',
   )
);
    
$wp_customize->add_control(new tromas_Customize_Dropdown_Taxonomies_Control($wp_customize,'tromas_blog_category_id',
    array(
               'label' => __('Select Category for Blog','tromas'),
                'section' => 'tromas_blog_section',
                'settings' => 'tromas_blog_category_id',
                'type'=> 'dropdown-taxonomies',
        )
));
$wp_customize->add_setting( 'tromas_blog_number', array(
    'capability'            => 'edit_theme_options',
    'default'               => '3',
    'sanitize_callback'     => 'tromas_sanitize_number_absint'
));

$wp_customize->add_control( 'tromas_blog_number', array(
    'label'                 =>  __( 'Number of Recent Blogs to Show in Front Page', 'tromas' ),
    'description'           =>  __( 'input 3,4,5,6,7,8,9,10', 'tromas' ),
    'section'               => 'tromas_blog_section',
    'type'                  => 'text',
    'settings' => 'tromas_blog_number',
) );
/*==============================================================================
===============================Latest Blog End==================================
===============================================================================*/

/*==============================================================================
===============================Contact Start==================================
===============================================================================*/
$wp_customize->add_section( 'tromas_contact_section', array(
    'capability'            => 'edit_theme_options',
    'title'                 => __( 'Front Contact Section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//Contact section enable disable
$wp_customize->add_setting( 'tromas_contact_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_contact_section_enable', array(
    'label'                 =>  __( 'Enable Contact Section', 'tromas' ),
    'section'               => 'tromas_contact_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_contact_section_enable',
) );

// Contact Page Title and Description
$wp_customize->add_setting( 'tromas_contact_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_contact_page_title', array(
    'label'                 =>  __( 'Select First Page for Contact', 'tromas' ),
    'section'               => 'tromas_contact_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_contact_page_title',
) );

$wp_customize->add_setting( 'tromas_contact_form_code', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
) );

$wp_customize->add_control( 'tromas_contact_form_code', array(
    'label'                 =>  __( 'Contact Section Use Shortcode', 'tromas' ),
    'description'           =>  __( 'eg [contact-form-7 id="108" title="Contact form 1"]', 'tromas' ),
    'section'               => 'tromas_contact_section',
    'type'                  => 'text',
    'settings' => 'tromas_contact_form_code',
) );
/*==============================================================================
============================Conatact Customizer End=============================
===============================================================================*/

/*==============================================================================
===============================Get In Touch Start===============================
===============================================================================*/
$wp_customize->add_section( 'tromas_touch_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Get In Touch Section', 'tromas' ),
    'description'           => __( 'Field for Get In Touch section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//Counter section enable disable
$wp_customize->add_setting( 'tromas_touch_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_touch_section_enable', array(
    'label'                 =>  __( 'Enable Get In Touch Section', 'tromas' ),
    'section'               => 'tromas_touch_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_touch_section_enable',
) );
// Contact Page Title and Description
$wp_customize->add_setting( 'tromas_touch_page_title', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_touch_page_title', array(
    'label'                 =>  __( 'Select First Page for Get In Touch', 'tromas' ),
    'section'               => 'tromas_touch_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_touch_page_title',
) );
$get_in_touch_arrays = array('1'=>'fa-phone','2'=>'fa-envelope','3'=>'fa-map');
foreach ($get_in_touch_arrays as $key => $get_in_touch) {
	$wp_customize->add_setting( 'tromas_touch_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_touch_'.$key, array(
	/* translators: %s: Description */ 
    'label'                 =>   sprintf( __( 'Type the title For Get In Touch %s', 'tromas' ), $key ),
    'section'               => 'tromas_touch_section',
    'type'                  => 'text',
    'settings' => 'tromas_touch_'.$key,
) );

$wp_customize->add_setting( 'tromas_touch_field_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_touch_field_'.$key, array(
	/* translators: %s: Description */ 
    'label'                 =>   sprintf( __( 'Type the description For Get In Touch %s', 'tromas' ), $key ),
    'section'               => 'tromas_touch_section',
    'type'                  => 'text',
    'settings' => 'tromas_touch_field_'.$key,
) );

$wp_customize->add_setting( 'tromas_touch_icon_'.$key, array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_touch_icon_'.$key, array(
	/* translators: %s: Label */ 
    'label'                 =>   sprintf( __( 'Icon For Get In Touch %s', 'tromas' ), $key),
    /* translators: %s: Description */ 
    'description'           => sprintf( __( 'Use font awesome icon: Eg:%1$s. %2$s See more here %3$s', 'tromas' ),$get_in_touch,'<a href="'.esc_url('http://fontawesome.io/icons/').'" target="_blank">','</a>'),
    'section'               => 'tromas_touch_section',
    'type'                  => 'text',
    'settings' => 'tromas_touch_icon_'.$key,
) );
}

/*==============================================================================
===============================Get In Touch End=================================
===============================================================================*/

/*==============================================================================
===============================Call to Action Start=============================
===============================================================================*/
$wp_customize->add_section( 'tromas_call_to_action_section', array(
    'capability'            => 'edit_theme_options',
     'title'                 => __( 'Front Call to Action Section', 'tromas' ),
    'description'           => __( 'Field for Call to Action section', 'tromas' ),
    'panel'             => 'tromas_frontpage_options'
) );

//Counter section enable disable
$wp_customize->add_setting( 'tromas_call_to_action_section_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_call_to_action_section_enable', array(
    'label'                 =>  __( 'Enable Call to Action Section', 'tromas' ),
    'section'               => 'tromas_call_to_action_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_call_to_action_section_enable',
) );

$wp_customize->add_setting( 'tromas_call_to_action_page_title', array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'tromas_sanitize_dropdown_pages'
) );

$wp_customize->add_control( 'tromas_call_to_action_page_title', array(
	/* translators: %s: Label */ 
	'label'                 =>  __( 'Select Page for Call to Action Title', 'tromas' ),
    'section'               => 'tromas_call_to_action_section',
    'type'                  => 'dropdown-pages',
    'settings'              => 'tromas_call_to_action_page_title',
) );

$wp_customize->add_setting( 'tromas_call_to_action_button_title', array(
	    'capability'            => 'edit_theme_options',
	    'default'               => '',
	    'sanitize_callback'     => 'sanitize_text_field'
	) );

$wp_customize->add_control( 'tromas_call_to_action_button_title', array(
    'label'                 =>  __( 'First Button Title For Call to Action', 'tromas' ),
    'description'           =>  __( 'Contact', 'tromas' ),
    'section'               => 'tromas_call_to_action_section',
    'type'                  => 'text',
    'settings' => 'tromas_call_to_action_button_title',
) );

$wp_customize->add_setting( 'tromas_call_to_action_button_url', array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'esc_url_raw'
) );

$wp_customize->add_control( 'tromas_call_to_action_button_url', array(
    'label'                 =>  __( 'Select URL For button of Call to Action', 'tromas'),
    'description'           =>  __( '#', 'tromas' ),
    'section'               => 'tromas_call_to_action_section',
    'type'                  => 'url',
    'settings' => 'tromas_call_to_action_button_url',
) );
/*==============================================================================
===============================Call to Action End=============================
===============================================================================*/