<?php

// Section: Header Social Icon.
$wp_customize->add_section( 'tromas_header_social_url_section', array(
	'priority'       => 1,
	'panel'          => 'tromas_theme_options',
	'title'          => __( 'Header Social Url', 'tromas' ),
	'capability'     => 'edit_theme_options'
));

//Header Socail Url Enable or disable by checkboxs

$wp_customize->add_setting( 'tromas_header_social_url_enable', array(
    'capability'            => 'edit_theme_options',
    'default'               => 0,
    'sanitize_callback'     => 'tromas_sanitize_checkbox'
) );

$wp_customize->add_control( 'tromas_header_social_url_enable', array(
    'label'                 =>  __( 'Enable Header Social Icon', 'tromas' ),
    'section'               => 'tromas_header_social_url_section',
    'type'                  => 'checkbox',
    'settings'              => 'tromas_header_social_url_enable',
) );

// Header Socail url
$social_name_arrays = array('Linkedin','Facebook','Twitter','Youtube','Behance');
foreach ($social_name_arrays as  $social_name) {
 	$wp_customize->add_setting( 'tromas_header_social_url_'.$social_name, array(
    'capability'            => 'edit_theme_options',
    'default'               => '',
    'sanitize_callback'     => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( 'tromas_header_social_url_'.$social_name, array(
        /* translators: %s: Label */ 
        'label'                 =>  sprintf( __( '%s Url', 'tromas' ), $social_name ),
	    'section'               => 'tromas_header_social_url_section',
	    'type'                  => 'text',
	    'settings' => 'tromas_header_social_url_'.$social_name,
    ) );
}

