<?php

if( ! class_exists( 'Tromas_Header_Opening_Phone_Widget' ) )
{
	class Tromas_Header_Opening_Phone_Widget extends WP_Widget{

	//setup the widget name, description, etc....
	public function __construct(){
		$widget_ops=array(
			'classname'	=>	'tromas-header-widget',
			'description'	=>	'Custom Troms Header Widget For Opening Time & Phone',
		);

		parent::__construct( 'tromas_opening_phone_header','Header Opening Time, Phone and Email Address',$widget_ops );
	}

	// Front-end display of widget
	public function widget( $args, $instance ) {
		echo $args['before_widget']; 
		$icon = isset( $instance['icon'] ) ? esc_attr( $instance['icon'] ) : '';
		$header_title  = isset( $instance['header_title'] ) ? esc_attr( $instance['header_title'] ) : '';
		$content  = isset( $instance['content'] ) ? esc_attr( $instance['content'] ) : '';
		?>
		<i class="fa <?php echo esc_attr( $icon );?>"></i><h4><?php echo esc_html( $header_title );?></h4>
		<?php $pattern = "/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,})$/i";
		if (preg_match($pattern,$content)){?>
  			<p><a href="mailto: <?php echo esc_attr( $content );?>"><?php echo esc_attr( $content );?></a></p>
		<?php }
		else{?>
			<p><?php echo esc_attr( $content );?></p>
		<?php }
	
		echo $args['after_widget'];
	}

	// Backend Widget form creation
	public function form($instance) {
	 	$header_title = '';
		$content = '';
		$icon = '';
		// Check values
		if( $instance) {
			$header_title = esc_attr($instance['header_title']);
			$content = esc_textarea($instance['content']);
			$icon = esc_textarea($instance['icon']);
		} ?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('icon') ); ?>"><?php esc_html_e('Icon:', 'tromas'); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('icon') ); ?>" name="<?php echo esc_attr( $this->get_field_name('icon') ); ?>" type="text" value="<?php echo esc_attr( $icon ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('header_title') ); ?>"><?php esc_html_e('Title', 'tromas'); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('header_title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('header_title') ); ?>" type="text" value="<?php echo esc_attr( $header_title ); ?>" />
		</p>
			 
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('content') ); ?>"><?php esc_html_e('Content:', 'tromas'); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('content') ); ?>" name="<?php echo esc_attr( $this->get_field_name('content') ); ?>" type="text" value="<?php echo esc_attr( $content ); ?>" />
		</p>
			
		<?php 
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['icon'] = strip_tags($new_instance['icon']);
		$instance['header_title'] = strip_tags($new_instance['header_title']);
		$instance['content'] = strip_tags($new_instance['content']);
		return $instance;
	}
}

}