<?php if ( ! defined( 'ABSPATH' ) ) exit;

$premium['bbpress'] = array(
	'url' => 'https://ultimatemember.com/extensions/bbpress/',
	'name' => 'bbPress',
	'desc' => 'With the bbPress extension you can integrate Ultimate Member with bbPress',
);

$premium['profile-completeness'] = array(
	'url' => 'https://ultimatemember.com/extensions/profile-completeness/',
	'name' => 'Profile Completeness',
	'desc' => 'Encourage or force users to complete their profile on your site',
);

$premium['verified-users'] = array(
	'url' => 'https://ultimatemember.com/extensions/verified-users/',
	'name' => 'Verified Users',
	'desc' => 'Add a user verficiation system to your site so user accounts can be verified',
);

$premium['friends'] = array(
	'url' => 'https://ultimatemember.com/extensions/friends/',
	'name' => 'Friends',
	'desc' => 'Increase user interaction on your site by allowing users to become friends',
);

$premium['woocommerce'] = array(
	'url' => 'https://ultimatemember.com/extensions/woocommerce/',
	'name' => 'WooCommerce',
	'desc' => 'Integrates the popular e-commerce plugin WooCommerce with Ultimate Member',
);

$premium['notices'] = array(
	'url' => 'https://ultimatemember.com/extensions/notices/',
	'name' => 'Notices',
	'desc' => 'Alert users to important information using conditional notices',
);

$premium['followers'] = array(
	'url' => 'https://ultimatemember.com/extensions/followers/',
	'name' => 'Followers',
	'desc' => 'Increase user interaction on your site by allowing users to follow each other',
);

$premium['mycred'] = array(
	'url' => 'https://ultimatemember.com/extensions/mycred/',
	'name' => 'myCRED',
	'desc' => 'With the myCRED extension you can integrate Ultimate Member with myCRED',
);

$premium['private-messages'] = array(
	'url' => 'https://ultimatemember.com/extensions/private-messages/',
	'name' => 'Private Messages',
	'desc' => 'Add a private messaging system to your site & allow users to message each other',
);

$premium['social-activity'] = array(
	'url' => 'https://ultimatemember.com/extensions/social-activity/',
	'name' => 'Social Activity',
	'desc' => 'Let users create public wall posts & see the activity of other users',
);

$premium['social-login'] = array(
	'url' => 'https://ultimatemember.com/extensions/social-login/',
	'name' => 'Social Login',
	'desc' => 'Let users register & login to your site via Facebook, Twitter, G+, LinkedIn, and more',
);

$premium['instagram'] = array(
	'url' => 'https://ultimatemember.com/extensions/instagram/',
	'name' => 'Instagram',
	'desc' => 'Allow users to show their Instagram photos on their profile',
);

$premium['user-tags'] = array(
	'url' => 'https://ultimatemember.com/extensions/user-tags/',
	'name' => 'User Tags',
	'desc' => 'With this extension you can add a user tag system to your website',
);


$premium['mailchimp'] = array(
	'url' => 'https://ultimatemember.com/extensions/mailchimp/',
	'name' => 'MailChimp',
	'desc' => 'Allow users to subscribe to your mailchimp lists when they signup on your site',
);


$premium['user-reviews'] = array(
	'url' => 'https://ultimatemember.com/extensions/user-reviews/',
	'name' => 'User Reviews',
	'desc' => 'Allow users to rate & review each other using a 5 star rate/review system',
);

$premium['real-time-notifications'] = array(
	'url' => 'https://ultimatemember.com/extensions/real-time-notifications/',
	'name' => 'Real-time Notifications',
	'desc' => 'Add a notifications system to your site so users can receive real-time notifications',
);

$premium['private-content'] = array(
	'url' => 'https://ultimatemember.com/extensions/private-content/',
	'name' => 'Private Content',
	'desc' => 'Display private content to logged in users that only they can access',
);

$premium['groups'] = array(
	'url' => 'https://ultimatemember.com/extensions/groups/',
	'name' => 'Groups',
	'desc' => 'Allow users to create and join groups around shared topics, interests etc.',
);

$premium['user-photos'] = array(
	'url' => 'https://ultimatemember.com/extensions/user-photos/',
	'name' => 'User Photos',
	'desc' => 'Allow users to upload photos to their profile',
);

$premium['user-bookmarks'] = array(
	'url' => 'https://ultimatemember.com/extensions/user-bookmarks/',
	'name' => 'User Bookmarks',
	'desc' => 'Allow users to bookmark content from your website',
);

$premium['unsplash'] = array(
	'url' => 'https://ultimatemember.com/extensions/unsplash/',
	'name' => 'Unsplash',
	'desc' => 'Allow users to select a profile cover photo from <a href="https://unsplash.com/" target="_blank">Unsplash</a> from their profile',
);

$free['forumwp'] = array(
	'url' => 'https://ultimatemember.com/extensions/forumwp/',
	'name' => 'ForumWP',
	'desc' => 'Integrates Ultimate Member with the forum plugin <a href="https://forumwpplugin.com" target="_blank">ForumWP</a>',
);

$free['online-users'] = array(
	'url' => 'https://ultimatemember.com/extensions/online-users/',
	'name' => 'Online Users',
	'desc' => 'Display online users on your site so users can see who is online'
);

$free['google-recaptcha'] = array(
	'url' => 'https://ultimatemember.com/extensions/google-recaptcha/',
	'name' => 'Google reCAPTCHA',
	'desc' => 'Stop bots on your registration & login forms with Google reCAPTCHA',
);

$free['terms-conditions'] = array(
	'url' => 'https://ultimatemember.com/extensions/terms-conditions/',
	'name' => 'Terms & Conditions',
	'desc' => 'Add terms & conditions to your registration form',
); ?>

<div id="um-extensions-wrap" class="wrap">

	<h2>Ultimate Member - Extensions</h2>

	<div class="wp-filter um-admin-notice um-filter">
		<div class="alignleft">
			<?php _e( '<strong>All Access Pass</strong> – Get access to all Ultimate Member extensions at a significant discount with our All Access Pass.', 'ultimate-member' ) ?>
		</div>
		<div class="alignright">
			<a href="https://ultimatemember.com/pricing/" class="button button-primary" target="_blank">
				<?php _e( 'View Pricing', 'ultimate-member' ) ?>
			</a>
		</div>
	</div>

	<div class="wp-filter">
		<ul class="filter-links">
			<li>
				<a href="?page=ultimatemember-extensions&filter=premium" class="<?php if ( ! isset( $_REQUEST['filter'] ) || isset( $_REQUEST['filter'] ) && $_REQUEST['filter'] == 'premium' ) { echo 'current'; } ?>">
					<?php _e( 'Premium', 'ultimate-member' ) ?>
				</a>
			</li>
			<li>
				<a href="?page=ultimatemember-extensions&filter=free" class="<?php if ( isset( $_REQUEST['filter'] ) && $_REQUEST['filter'] == 'free' ) { echo 'current'; } ?>">
					<?php _e( 'Free', 'ultimate-member' ) ?>
				</a>
			</li>
		</ul>
	</div>

	<div class="wp-list-table widefat plugin-install">
		<div id="the-list">
			<?php if ( ! isset( $_REQUEST['filter'] ) || isset( $_REQUEST['filter'] ) && $_REQUEST['filter'] == 'premium' ) {
				foreach ( $premium as $key => $info ) { ?>

					<div class="plugin-card">
						<a href="<?php echo esc_url( $info['url'] ); ?>" class="plugin-image">
							<img src="<?php echo esc_url( um_url . 'assets/img/extensions/' . $key . '.png'  ); ?>" alt="<?php echo esc_attr( $info['name'] ) ?>" />
						</a>
						<div class="plugin-card-top">
							<h3><a href="<?php echo esc_url( $info['url'] ); ?>"><?php echo $info['name']; ?></a></h3>

							<div class="desc column-description">
								<?php echo $info['desc']; ?>
							</div>

							<div class="action-links">
								<ul class="plugin-action-buttons">
									<li>
										<a class="install-now button" href="<?php echo esc_url( $info['url'] ); ?>">
											<?php _e( 'Get this Add on', 'ultimate-member' ) ?>
										</a>
									</li>
									<li>
										<a href="<?php echo esc_url( $info['url'] ); ?>">
											<?php _e( 'More Details', 'ultimate-member' ) ?>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>

				<?php }
			}

			if ( isset( $_REQUEST['filter'] ) && $_REQUEST['filter'] == 'free' ) {
				foreach ( $free as $key => $info ) { ?>

					<div class="plugin-card">
						<a href="<?php echo esc_url( $info['url'] ); ?>" class="plugin-image">
							<img src="<?php echo esc_url( um_url . 'assets/img/extensions/' . $key . '.png'  ); ?>" alt="<?php echo esc_attr( $info['name'] ) ?>" />
						</a>
						<div class="plugin-card-top">
							<h3><a href="<?php echo esc_url( $info['url'] ); ?>"><?php echo $info['name']; ?></a></h3>

							<div class="desc column-description">
								<?php echo $info['desc']; ?>
							</div>

							<div class="action-links">
								<ul class="plugin-action-buttons">
									<li>
										<a class="install-now button" href="<?php echo esc_url( $info['url'] ); ?>">
											<?php _e( 'Get this Add on', 'ultimate-member' ) ?>
										</a>
									</li>
									<li>
										<a href="<?php echo $info['url']; ?>">
											<?php _e( 'More Details', 'ultimate-member' ) ?>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>

				<?php }
			} ?>

		</div>
	</div>
</div>
<div class="um-admin-clear"></div>