<?php
/**
* The template for displaying the footer
*
* Contains the closing of the #content div and all content after.
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package Tromas
*/
?>
<!-- Start Footer -->
<footer id="footer" class="footer">
	<div class="footer-top">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-6 col-12">
					<!-- Address Widget -->
					<?php if ( is_active_sidebar( 'footer-1-widget' ) ) { ?>
					<?php dynamic_sidebar( 'footer-1-widget' );?>
					<?php } ?>
					<!--/ End Address Widget -->
				</div>	
				<div class="col-lg-3 col-md-6 col-12">
					<!-- Links Widget -->
					<?php if ( is_active_sidebar( 'footer-2-widget' ) ) { ?>
					<?php dynamic_sidebar( 'footer-2-widget' );?>
					<?php } ?>
					<!--/ End Links Widget -->
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<!-- Twitter Widget -->
					<?php if ( is_active_sidebar( 'footer-3-widget' ) ) { ?>
					<?php dynamic_sidebar( 'footer-3-widget' );?>
					<?php } ?>
					<!--/ End Twitter Widget -->
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<!-- Gallery Widget -->
					<?php if ( is_active_sidebar( 'footer-4-widget' ) ) { ?>
					<?php dynamic_sidebar( 'footer-4-widget' );?>
					<?php } ?>
					<!--/ End Gallery Widget -->
				</div>
			</div>
		</div>
	</div>
	<div class="footer-bottom">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<!-- copyright -->
					<div class="copyright">
						<p>
							<?php esc_html_e('&copy; All Right Reserved ','tromas');  echo  esc_html(date('Y'));?> <?php esc_html(bloginfo('name')); ?>
						</p>
					</div>
					<!--/ End Copyright -->
				</div>
			</div>
		</div>
	</div>
</footer>
<!--/ End footer -->


<?php wp_footer(); ?>
</div>
</body>
</html>
