<?php
/**
 * Tromas functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Tromas
 */

if ( ! function_exists( 'tromas_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function tromas_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Troms, use a find and replace
		 * to change 'tromas' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'tromas' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		add_image_size('tromas-slider-thumb',1349,580,true);
		add_image_size('tromas-about-thumb',441,294,true);
		add_image_size('tromas-faq-thumb',458,416,true);
		add_image_size('tromas-project-thumb',340,260,true);
		add_image_size('tromas-team-thumb',262,295,true);
		add_image_size('tromas-team-thumb-sidebar',415,467,true);
		add_image_size('tromas-testimonial-thumb',74,74,true);
		add_image_size('tromas-client-thumb',163,74,true);
		add_image_size('tromas-blog-thumb1',499,281,true);
		add_image_size('tromas-blog-thumb2',340,226,true);
		add_image_size('tromas-photo-gallery-thumb',366,252,true);
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'tromas' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'tromas_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'tromas_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function tromas_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'tromas_content_width', 640 );
}
add_action( 'after_setup_theme', 'tromas_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function tromas_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'tromas' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-sidebar %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => esc_html__( 'Header Widget', 'tromas' ),
		'id'            => 'header-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Pricing Table Widget', 'tromas' ),
		'id'            => 'pricing-table-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 1', 'tromas' ),
		'id'            => 'footer-1-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget address %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 2', 'tromas' ),
		'id'            => 'footer-2-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget links %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 3', 'tromas' ),
		'id'            => 'footer-3-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget twitter %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 4', 'tromas' ),
		'id'            => 'footer-4-widget',
		'description'   => esc_html__( 'Add widgets here.', 'tromas' ),
		'before_widget' => '<div id="%1$s" class="single-widget photo-gallery %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Google map iframe', 'tromas' ),
		'id'            => 'google-map',
		'description'   => __( 'Add widgets here.', 'tromas' ),
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'tromas_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function tromas_scripts() {

	//Web Font
	wp_enqueue_style( 'google-font', 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900', array(), '' );

	// Bootstrap CSS 
	wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() .'/assets/css/bootstrap.min.css', array(), '4.0.0' );

	// Animate Text CSS
	wp_enqueue_style( 'animate-text-css', get_template_directory_uri() .'/assets/css/animate-text.css', array(), '1.0.0' );	

	// Animate CSS
	wp_enqueue_style( 'animate-css', get_template_directory_uri() .'/assets/css/animate.min.css', array(), '1.0.0' );
 
    // Cubeportfolio CSS
    wp_enqueue_style( 'cubeportfolio-css', get_template_directory_uri() .'/assets/css/cubeportfolio.min.css', array(), '4.3.0' );
	
	// <!-- Bxslider CSS -->
	wp_enqueue_style( 'bxslider-css', get_template_directory_uri() .'/assets/css/bxslider.min.css', array(), '1.0.0' );
    
	// <!-- fancybox CSS -->
	wp_enqueue_style( 'fancybox-css', get_template_directory_uri() .'/assets/css/fancybox.min.css', array(), '1.0.0' );
    
	// <!-- Fontawesome CSS -->
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() .'/assets/css/font-awesome.min.css', array(), '4.7.0' );

	// <!-- Owl carousel CSS -->
	wp_enqueue_style( 'owl-carousel-css', get_template_directory_uri() .'/assets/css/owl-carousel.css', array(), '2.2.1' );
  
	// <!-- Magnificpopup CSS -->
	wp_enqueue_style( 'magnific-popup-css', get_template_directory_uri() .'/assets/css/magnific-popup.min.css', array(), '1.0.0' );

	// <!-- Perfectscrollbar CSS -->
	wp_enqueue_style( 'perfect-scrollbar-css', get_template_directory_uri() .'/assets/css/perfect-scrollbar.min.css', array(), '0.8.1' );
    
	// <!-- Slicknav CSS -->
	wp_enqueue_style( 'slicknav-css', get_template_directory_uri() .'/assets/css/slicknav.min.css', array(), '1.0.10' );
    
	// <!-- Tromas CSS -->
	wp_enqueue_style( 'style-css', get_stylesheet_uri() );
  
    wp_enqueue_style( 'tromas-responsive-css', get_template_directory_uri() .'/assets/css/responsive.css', array(), '1.1.0' );

	// <!-- Tromas Color -->
	wp_enqueue_style( 'tromas-skin-color-css', get_template_directory_uri() .'/assets/css/skin/skin5.css', array(), '1.1.0' );
	
	// <!-- Popper JS -->
	wp_enqueue_script( 'popup-js', get_template_directory_uri() . '/assets/js/popper.min.js', array('jquery'), '1.0.0', true );

	// <!-- Bootstrap JS -->
	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '4.0.0', true );

	// <!-- Cubeportfolio JS -->
	wp_enqueue_script( 'jquery-cubeportfolio-js', get_template_directory_uri() . '/assets/js/cubeportfolio.min.js', array('jquery'), '4.3.0', true );

	// <!-- Animate Text JS -->
	wp_enqueue_script( 'animate-text-js', get_template_directory_uri() . '/assets/js/animate-text.js', array('jquery'), '1.0.0', true );

	// <!-- FinalCountdown JS -->
	wp_enqueue_script( 'finalcountdown-js', get_template_directory_uri() . '/assets/js/finalcountdown.min.js', array('jquery'), '2.2.0', true );

	// <!-- ScrollUp JS -->
	wp_enqueue_script( 'scrollup-js', get_template_directory_uri() . '/assets/js/scrollup.min.js', array('jquery'), '2.4.1', true );

	// <!-- Bxslider JS -->
	wp_enqueue_script( 'bxslider-js', get_template_directory_uri() . '/assets/js/bxslider.min.js', array('jquery'), '4.2.12', true );

	// <!-- Modernizer JS -->
	wp_enqueue_script( 'modernizr-js', get_template_directory_uri() . '/assets/js/modernizr.min.js', array('jquery'), '3.5.0', true );
	
	// <!-- Steller JS -->
	wp_enqueue_script( 'jquery-steller-js', get_template_directory_uri() . '/assets/js/jquery-steller.min.js', array('jquery'), '1.0.0', true );
	
	// <!-- Slicknav JS -->
	wp_enqueue_script( 'jquery-magnific-popup-js', get_template_directory_uri() . '/assets/js/slicknav.min.js', array('jquery'), '1.0.10', true );
	
	// <!-- Onepagenav JS -->
	wp_enqueue_script( 'onepagenav-js', get_template_directory_uri() . '/assets/js/onepagenav.min.js', array('jquery'), '3.0.0', true );

	// <!-- Waypoints JS -->
	wp_enqueue_script( 'waypoints-js', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), '2.0.3', true );
	
	// <!-- Counterup JS -->
	wp_enqueue_script( 'counterup-js', get_template_directory_uri() . '/assets/js/counterup.min.js', array('jquery'), '1.0.0', true );
	
	// <!-- Owl Carousel JS -->
	wp_enqueue_script( 'owl-carousel-js', get_template_directory_uri() . '/assets/js/owl-carousel.min.js', array('jquery'), '2.2.1', true );

	// <!-- Easing JS -->
	wp_enqueue_script( 'easing-js', get_template_directory_uri() . '/assets/js/easing.min.js', array('jquery'), '1.0.0', true );
	
	// <!-- Fancybox JS -->
	wp_enqueue_script( 'fancybox-js', get_template_directory_uri() . '/assets/js/fancybox.min.js', array('jquery'), '3.1.20', true );

	// <!-- Mouse Parallax JS -->
	wp_enqueue_script( 'mouseparallax-js', get_template_directory_uri() . '/assets/js/mouseparallax.js', array('jquery'), '1.0.0', true );

	// <!-- Typed JS -->
	wp_enqueue_script( 'typed-js', get_template_directory_uri() . '/assets/js/typed.min.js', array('jquery'), '1.0.0', true );
	
	// <!-- Perfectscrollbar JS -->
	wp_enqueue_script( 'perfectscrollbar-js', get_template_directory_uri() . '/assets/js/perfectscrollbar.min.js', array('jquery'), '0.8.1', true );

	// <!-- Magnificpopup JS -->
	wp_enqueue_script( 'magnificpopup-js', get_template_directory_uri() . '/assets/js/magnificpopup.min.js', array('jquery'), '1.1.0', true );

	
	
	// <!-- matchHeight JS -->
	wp_enqueue_script( 'matchheight-js', get_template_directory_uri() . '/assets/js/jquery.matchHeight.js', array('jquery'), '0.7.2', true );
	
	// <!-- Main JS -->
	wp_enqueue_script( 'tromas-main-js', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0.0', true );

	wp_enqueue_script( 'tromas-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'tromas-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'tromas_scripts' );

/*Bootstrap Pagination Function*/
function tromas_portfolio_bs_pagination($pages = '', $range = 4)
{  
     $showitems = ($range * 2) + 1;  
     $paged = get_query_var( 'paged');
    
     if(empty($paged)) $paged = 1;
     if($pages == '')
     {
         global $wp_query; 
		 $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   
 
     if(1 != $pages)
    {
       	echo '<ul class="pagination">';
         if($paged > 1 ) echo "<li class='prev'><a href='".esc_url(get_pagenum_link($paged - 1))."'><i class='fa fa-angle-double-left'></i></a></li>";
         for ($i=1; $i <= $pages; $i++)
         {
            if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                echo ($paged == $i)? "<li class=\"active\"><a href='".esc_url(get_pagenum_link($i))."'>".esc_html($i)."</a></li>":"<li><a href='".esc_url(get_pagenum_link($i))."'>".esc_html($i)."</a></li>";
             }
         }
 
         if ($paged < $pages ) echo "<li class='next'><a href=\"".esc_url(get_pagenum_link($paged + 1))."\"><i class='fa fa-angle-double-right'></i></a></li>";  
         echo "</ul>";
    }
}
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */

/**
 * Custom widget.
 */
require get_template_directory() . '/inc/widget.php';

/*
*Bootstrap Navigation
*/
require get_template_directory() . '/inc/wp-bootstrap-navwalker.php';

/*
* Latests and popular posts Widget
*/
require get_template_directory() . '/inc/latest-popular-posts-widget.php';

if ( ! function_exists( 'tromas_simple_breadcrumb' ) ) :

    /**
     * Simple breadcrumb.
     *
     * @since 1.0.0
     */
    function tromas_simple_breadcrumb() {
        $breadcrumb_args = array(
            'container'   => 'div',
            'show_browse' => false,
        );
        breadcrumb_trail( $breadcrumb_args );

    }

endif;

add_action( 'tromas_breadcrumb', 'tromas_simple_breadcrumb', 10 );

/*
*Breadcrumb function file
*/
require get_template_directory() . '/inc/breadcrumbs.php';


function tromas_get_cat_postcount($id) {
    $cat = get_category($id);
    $count = (int) $cat->count;
    $taxonomy = 'category';
    $args = array(
      'child_of' => $id,
    );
    $tax_terms = get_terms($taxonomy,$args);
    foreach ($tax_terms as $tax_term) {
        $count +=$tax_term->count;
    }
    return $count;
}

if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

