<?php
/**
 * Troms Theme Customizer
 *
 * @package Tromas
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function tromas_customize_register( $wp_customize ) {
	$wp_customize->get_control('header_textcolor')->label = __('Site Tagline Color', 'tromas');
	$wp_customize->get_control('header_textcolor')->priority = 2;
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	// Sanitization Callback
	require_once trailingslashit( get_template_directory() ) . '/inc/sanitize.php'; 

	require_once trailingslashit( get_template_directory() ) . '/inc/upgrade-to-pro/control.php';

	//Upgrade to Pro
	// Register custom section types.
	$wp_customize->register_section_type( 'tromas_Customize_Section_Upsell' );

	// Register sections.
	$wp_customize->add_section(
		new tromas_Customize_Section_Upsell(
			$wp_customize,
			'theme_upsell',
			array(
				'title'    => esc_html__( 'Go Pro', 'tromas' ),
				'pro_text' => esc_html__( 'Buy Tromas Plus', 'tromas' ),
				'pro_url'  => 'https://codeglim.com/downloads/tromas-plus-multipurpose-premium-wordpress-theme/',
				'priority' => 1,
			)
		)
	);
	// Setting: sitetag
	$wp_customize->add_setting( 'tromas_sitetag_enable', array(
		 'capability'		    => 'edit_theme_options',
    	'default'			    => 0,
    	'sanitize_callback'     => 'tromas_sanitize_checkbox'
	) );
	
	$wp_customize->add_control( 'tromas_sitetag_enable', array(
    'label'                 =>  __( 'Enable Site Tagline', 'tromas' ),
    'section'               => 'colors',
    'type'                  => 'checkbox',
    'priority'              => 0,
    'settings'              => 'tromas_sitetag_enable',
	) );

	$wp_customize->add_setting( 'tromas_header_title_color', array(
        'capability'        => 'edit_theme_options',
        'default'           => '#000000',
        'sanitize_callback' => 'tromas_sanitize_hex_color'
    ) );

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'tromas_header_title_color',array(
	          'label'                 =>  __( 'Site title color', 'tromas' ),
	          'section'               => 'colors',
	          'type'                  => 'color',
	          'priority'              => 1,
	          'settings' => 'tromas_header_title_color',
	      ) )
	);
	
	$wp_customize->add_setting( 'tromas_header_menu_color', array(
        'capability'        => 'edit_theme_options',
        'default'           => '#FFFFFF',
        'sanitize_callback' => 'tromas_sanitize_hex_color'
    ) );

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'tromas_header_menu_color',array(
	          'label'                 =>  __( 'Menu color', 'tromas' ),
	          'section'               => 'colors',
	          'type'                  => 'color',
	          'priority'              => 3,
	          'settings' => 'tromas_header_menu_color',
	      ) )
	);
	

	// Panel: Troms Theme Options.
	$wp_customize->add_panel( 'tromas_theme_options', array(
		'priority'       => 1,
		'title'          => __( 'Theme Options', 'tromas' ),
		'capability'     => 'edit_theme_options'
	) );

	// Panel: Front Page Options.
	$wp_customize->add_panel( 'tromas_frontpage_options', array(
		'priority'       => 2,
		'title'          => __( 'Front Page Options', 'tromas' ),
		'capability'     => 'edit_theme_options'
	) );

	// Customizer for header social icon
	require get_template_directory() . '/inc/header-social-url-customizer.php';

	//Customizer for Frontpage Section 
	require get_template_directory() . '/inc/frontpage-section-customizer.php';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'tromas_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'tromas_customize_partial_blogdescription',
		) );
	}
}
add_action( 'customize_register', 'tromas_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function tromas_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function tromas_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function tromas_customize_preview_js() {
	wp_enqueue_script( 'tromas-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'tromas_customize_preview_js' );

function tromas_customizer_control_scripts() {

	wp_enqueue_script( 'tromas-customize-controls', get_template_directory_uri() . '/inc/upgrade-to-pro/customize-controls.js', array( 'customize-controls' ) );

	wp_enqueue_style( 'tromas-customize-controls', get_template_directory_uri() . '/inc/upgrade-to-pro/customize-controls.css' );

}

add_action( 'customize_controls_enqueue_scripts', 'tromas_customizer_control_scripts', 0 );

