<?php
// Popular and Latest Post Widget
/*Method to load popular posts*/
function tromas_tabs_popular_posts( $posts = 5 ) {
	$posts_args = array(
		'post_type'			=> 'post',
		'posts_per_page'	=> $posts,
	 	'orderby'       => 'comment_count',
		'order'				=> 'DESC'
	);
	$popular = new WP_Query( $posts_args );
	$popular_post_num = 1;
	while ($popular->have_posts()) : $popular->the_post();
	?>
	<div class="single-post">
		<div class="post-img">
			<?php the_post_thumbnail();?>
		</div>
		<div class="post-info">
			<p><?php echo get_the_date( 'j F, Y'); ?></p>
			<h4><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a></h4>
		</div>
	</div>
	<?php
	endwhile; 
}

/*Method to load latest posts*/
function tromas_tabs_latest_posts( $posts = 5 ) 
{
	$the_query = new WP_Query('showposts='. $posts .'&orderby=post_date&order=desc');
	$recent_post_num = 1;		
	while ($the_query->have_posts()) : $the_query->the_post(); 
	?>
	<div class="single-post">
		<div class="post-img">
			<?php the_post_thumbnail();?>
		</div>
		<div class="post-info">
			<p><?php echo get_the_date( 'j F, Y'); ?></p>
			<h4><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a></h4>
		</div>
	</div>
	<?php
	endwhile; 
}