<?php 
if( !class_exists('Tromas_Pricing_Table_Widget')){
	class Tromas_Pricing_Table_Widget extends WP_Widget{
		// setup the widget name, description etc.

public function __construct(){
	$widget_ops =  array('
		classname' => 'tromas-pricing-table-widget',
		'description' => 'Custom Pricing Table widget'
	);

	parent::__construct( 'tromas_pricing_table','Pricing Table Widget',$widget_ops);
}

public function widget( $arg, $instance){?>
	<?php
	$p_table_background_icon  = isset( $instance['p_table_background_icon'] ) ? esc_attr( $instance['p_table_background_icon'] ) : '';
	$p_table_price  = isset( $instance['p_table_price'] ) ? esc_attr( $instance['p_table_price'] ) : '';
	$p_table_title  = isset( $instance['p_table_title'] ) ? esc_attr( $instance['p_table_title'] ) : '';
	$p_table_feature_1_check = isset( $instance['p_table_feature_1_enable'] ) ? esc_attr( $instance['p_table_feature_1_enable'] ) : '';
	$p_table_feature_2_check = isset( $instance['p_table_feature_2_enable'] ) ? esc_attr( $instance['p_table_feature_2_enable'] ) : '';
	$p_table_feature_3_check = isset( $instance['p_table_feature_3_enable'] ) ? esc_attr( $instance['p_table_feature_3_enable'] ) : '';
	$p_table_feature_4_check = isset( $instance['p_table_feature_4_enable'] ) ? esc_attr( $instance['p_table_feature_4_enable'] ) : '';
	$p_table_feature_5_check = isset( $instance['p_table_feature_5_enable'] ) ? esc_attr( $instance['p_table_feature_5_enable'] ) : '';
	$p_table_feature_6_check = isset( $instance['p_table_feature_6_enable'] ) ? esc_attr( $instance['p_table_feature_6_enable'] ) : '';
	$p_table_feature_1 = isset( $instance['p_table_feature_1'] ) ? esc_attr( $instance['p_table_feature_1'] ) : '';
	$p_table_feature_2 = isset( $instance['p_table_feature_2'] ) ? esc_attr( $instance['p_table_feature_2'] ) : '';
	$p_table_feature_3 = isset( $instance['p_table_feature_3'] ) ? esc_attr( $instance['p_table_feature_3'] ) : '';
	$p_table_feature_4 = isset( $instance['p_table_feature_4'] ) ? esc_attr( $instance['p_table_feature_4'] ) : '';
	$p_table_feature_5 = isset( $instance['p_table_feature_5'] ) ? esc_attr( $instance['p_table_feature_5'] ) : '';
	$p_table_feature_6 = isset( $instance['p_table_feature_6'] ) ? esc_attr( $instance['p_table_feature_6'] ) : '';
	$p_table_link 	= isset( $instance['p_table_link'] ) ? esc_attr( $instance['p_table_link'] ) : '';
	$p_table_text 	= isset( $instance['p_table_text'] ) ? esc_attr( $instance['p_table_text'] ) : '';
	$p_table_feature_1_enable = $p_table_feature_1_check ? 'true' : 'false';
	$p_table_feature_2_enable = $p_table_feature_2_check ? 'true' : 'false';
	$p_table_feature_3_enable = $p_table_feature_3_check ? 'true' : 'false';
	$p_table_feature_4_enable = $p_table_feature_4_check ? 'true' : 'false';
	$p_table_feature_5_enable = $p_table_feature_5_check ? 'true' : 'false';
	$p_table_feature_6_enable = $p_table_feature_6_check ? 'true' : 'false';?>
		<div class="col-lg-4 col-12">
			<div class="single-table">
				<div class="bg-icon">
					<i class="fa <?php echo esc_attr($p_table_background_icon);?>"></i>
				</div>
				<!-- Table Head -->
				<div class="table-head">
					<div class="price">
						<p class="amount">$<?php echo absint( $p_table_price);?></p>
					</div>	
					<h2 class="title"><?php echo esc_html( $p_table_title );?></h2>
				</div>

				<!-- Table List -->
				<ul class="table-list">
					<li class="<?php echo ((esc_attr($p_table_feature_1_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_1_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_1);?></li>
					<li class="<?php echo ((esc_attr($p_table_feature_2_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_2_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_2);?></li>
					<li class="<?php echo ((esc_attr($p_table_feature_3_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_3_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_3);?></li>
					<li class="<?php echo ((esc_attr($p_table_feature_4_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_4_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_4);?></li>
					<li class="<?php echo ((esc_attr($p_table_feature_5_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_5_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_5);?></li>
					<li class="<?php echo ((esc_attr($p_table_feature_6_enable =='false')) ? 'cross' : '');?>"><i class="fa <?php echo ((esc_attr($p_table_feature_6_enable =='false')) ? 'fa-remove' : 'fa-angle-right');?>"></i><?php echo esc_html($p_table_feature_6);?></li>
				</ul>

				<!-- Table Bottom -->
				<div class="table-bottom">
					<a class="btn primary" href="<?php echo esc_url($p_table_link);?>"><i class="fa fa-shopping-cart"></i><?php echo esc_html($p_table_text);?></a>
				</div>
			</div>
		</div>
	
<?php }

function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance[ 'p_table_background_icon' ] = strip_tags( $new_instance[ 'p_table_background_icon' ] );
    $instance[ 'p_table_price' ] = strip_tags( $new_instance[ 'p_table_price' ] );
	$instance[ 'p_table_title' ] = strip_tags( $new_instance[ 'p_table_title' ] );
	$instance[ 'p_table_feature_1' ] = strip_tags( $new_instance[ 'p_table_feature_1' ] );
	$instance[ 'p_table_feature_1_enable' ] = $new_instance[ 'p_table_feature_1_enable' ];
	$instance[ 'p_table_feature_2' ] = strip_tags( $new_instance[ 'p_table_feature_2' ] );
	$instance[ 'p_table_feature_2_enable' ] = $new_instance[ 'p_table_feature_2_enable' ];
	$instance[ 'p_table_feature_3' ] = strip_tags( $new_instance[ 'p_table_feature_3' ] );
	$instance[ 'p_table_feature_3_enable' ] = $new_instance[ 'p_table_feature_3_enable' ];
	$instance[ 'p_table_feature_4' ] = strip_tags( $new_instance[ 'p_table_feature_4' ] );
	$instance[ 'p_table_feature_4_enable' ] = $new_instance[ 'p_table_feature_4_enable' ];
	$instance[ 'p_table_feature_5' ] = strip_tags( $new_instance[ 'p_table_feature_5' ] );
	$instance[ 'p_table_feature_5_enable' ] = $new_instance[ 'p_table_feature_5_enable' ];
	$instance[ 'p_table_feature_6' ] = strip_tags( $new_instance[ 'p_table_feature_6' ] );
	$instance[ 'p_table_feature_6_enable' ] = $new_instance[ 'p_table_feature_6_enable' ];
	$instance[ 'p_table_link' ] = strip_tags( $new_instance[ 'p_table_link' ] );
	$instance[ 'p_table_text' ] = strip_tags( $new_instance[ 'p_table_text' ] );
    
    return $instance;
}
// Backend Widget form creation
function form($instance) {
$p_table_background_icon = '';
	$p_table_price	= '';
$p_table_title	= '';
$p_table_feature_1 = '';
$p_table_feature_1_enable = '';
$p_table_feature_2 = '';
$p_table_feature_2_enable = '';
$p_table_feature_3 = '';
$p_table_feature_3_enable = '';
$p_table_feature_4 = '';
$p_table_feature_4_enable = '';
$p_table_feature_5 = '';
$p_table_feature_5_enable = '';
$p_table_feature_6 = '';
$p_table_feature_6_enable = '';
$p_table_link = '';
$p_table_text = '';
if( $instance) {
	$p_table_background_icon = esc_attr($instance['p_table_background_icon']);
	$p_table_price = esc_textarea($instance['p_table_price']);
	$p_table_title = esc_textarea($instance['p_table_title']);
	$p_table_feature_1 = esc_textarea($instance['p_table_feature_1']);
	
	$p_table_feature_2 = esc_textarea($instance['p_table_feature_2']);
	
	$p_table_feature_3 = esc_textarea($instance['p_table_feature_3']);

	$p_table_feature_4 = esc_textarea($instance['p_table_feature_4']);

	$p_table_feature_5 = esc_textarea($instance['p_table_feature_5']);
	
	$p_table_feature_6 = esc_textarea($instance['p_table_feature_6']);

	$p_table_link = esc_url($instance['p_table_link']);
	$p_table_text = esc_textarea($instance['p_table_text']);


}
/*For checkbox*/
$defaults = array( 'p_table_feature_1_enable' => 'off','p_table_feature_2_enable' => 'off','p_table_feature_3_enable' => 'off','p_table_feature_4_enable' => 'off','p_table_feature_5_enable' => 'off','p_table_feature_6_enable' => 'off' );
$instance = wp_parse_args( ( array ) $instance, $defaults ); 
?>	

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_background_icon') ); ?>">
		<?php echo esc_html_e('Use font awesome icon: Eg:fa-bicycle.', 'tromas' );?><a href="<?php echo esc_url('http://fontawesome.io/icons/');?>" target="_blank"><?php echo esc_html_e( 'See more here', 'tromas' );?>  </a>
	</label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_background_icon') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_background_icon') ); ?>" type="text" value="<?php echo esc_attr( $p_table_background_icon ); ?>" />
</p>
	 
<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_price') ); ?>"><?php esc_html_e('Price', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_price') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_price') ); ?>" type="text" value="<?php echo esc_attr( $p_table_price );?>"/>
</p>

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_title') ); ?>"><?php esc_html_e('Title', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_title') ); ?>" type="text" value="<?php echo esc_attr( $p_table_title );?>"/>
</p>

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_1') ); ?>"><?php esc_html_e('Feature one', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_1') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_1') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_1 );?>"/>
</p>	

<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_1_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_1_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_1_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_1_enable' )); ?>"><?php esc_html_e('Feature One Enable', 'tromas'); ?></label>
</p>	

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_2') ); ?>"><?php esc_html_e('Feature Two', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_2') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_2') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_2 );?>"/>
</p>	

<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_2_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_2_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_2_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_2_enable' )); ?>"><?php esc_html_e('Feature Two Enable', 'tromas'); ?></label>
</p>	

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_3') ); ?>"><?php esc_html_e('Feature Three', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_3') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_3') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_3 );?>"/>
</p>	

<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_3_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_3_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_3_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_3_enable' )); ?>"><?php esc_html_e('Feature Three Enable', 'tromas'); ?></label>
</p>		

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_4') ); ?>"><?php esc_html_e('Feature Four', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_4') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_4') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_4 );?>"/>
</p>
<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_4_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_4_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_4_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_4_enable' )); ?>"><?php esc_html_e('Feature Four Enable', 'tromas'); ?></label>
</p>		

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_5') ); ?>"><?php esc_html_e('Feature Five', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_5') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_5') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_5 );?>"/>
</p>	

<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_5_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_5_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_5_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_5_enable' )); ?>"><?php esc_html_e('Feature Five Enable', 'tromas'); ?></label>
</p>	


<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_feature_6') ); ?>"><?php esc_html_e('Feature Six', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_feature_6') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_feature_6') ); ?>" type="text" value="<?php echo esc_attr( $p_table_feature_6 );?>"/>
</p>	

<p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'p_table_feature_6_enable' ], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id( 'p_table_feature_6_enable' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'p_table_feature_6_enable' ) ); ?>" /> 
    <label for="<?php echo esc_attr($this->get_field_id( 'p_table_feature_6_enable' )); ?>"><?php esc_html_e('Feature Six Enable', 'tromas'); ?></label>
</p>	

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_link') ); ?>"><?php esc_html_e('Pricing Link', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_link') ); ?>" type="text" value="<?php echo esc_attr( $p_table_link );?>"/>
</p>	

<p>
	<label for="<?php echo esc_attr( $this->get_field_id('p_table_text') ); ?>"><?php esc_html_e('Pricing Link Text', 'tromas'); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('p_table_text') ); ?>" name="<?php echo esc_attr( $this->get_field_name('p_table_text') ); ?>" type="text" value="<?php echo esc_attr( $p_table_text );?>"/>
</p>	
<?php	}
	}
}
