<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Tromas
 */

get_header();
?>

<!-- Start Blog -->
<section id="blog-main" class="blog-main archive single section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="blog-main">	
					<div class="row">
						<div class="col-lg-8 col-12">
							<div class="row">
								<div class="col-12">
									<?php if ( have_posts() ) : ?>
											<header class="page-header">
												<h1 class="page-title">
													<?php
													/* translators: %s: search query. */
													printf( esc_html__( 'Search Results for: %s', 'tromas' ), '<span>' . get_search_query() . '</span>' );
													?>
												</h1>
											</header><!-- .page-header -->

											<?php
											/* Start the Loop */
											while ( have_posts() ) :
												the_post();

												/**
												 * Run the loop for the search to output the results.
												 * If you want to overload this in a child theme then include a file
												 * called content-search.php and that will be used instead.
												 */
												get_template_part( 'template-parts/content', 'search' );

											endwhile;

											the_posts_navigation();

										else :

											get_template_part( 'template-parts/content', 'none' );

										endif;
										?>
								</div>
							</div>
						</div>
						<div class="col-lg-4 col-12">
							<!-- Blog Sidebar -->
								<?php get_sidebar();?>
							<!--/ End Blog Sidebar -->
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
