<?php if(get_theme_mod('tromas_blog_section_enable')): ?>
<!-- Start Blogs -->
<section id="blog-main" class="blog-main section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$blog_title = get_theme_mod('tromas_blog_page_title');
						$queried_post = get_post($blog_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="blog-main">
			<div class="row">		
				<div class="col-lg-10 offset-lg-1 col-12">
					<!-- Blog Sticky -->
					<?php
						$blog_feature_title =  get_theme_mod( 'tromas_blog_feature_post_title' );
						$queried_post =  get_post($blog_feature_title);
					?>
					<div class="single-blog sticky">
						<div class="blog-post">
							<?php if (has_post_thumbnail( $blog_feature_title ) ): ?>
								<div class="blog-head">
									<?php echo get_the_post_thumbnail($blog_feature_title,'tromas-blog-thumb1');?>
								</div>
							<?php endif;?>
							<div class="blog-info">
								<h2><a href="<?php echo esc_url(get_permalink($blog_feature_title));?>"><?php echo esc_html($queried_post->post_title); ?></a></h2>
								<div class="meta">
									<span><i class="fa fa-list"></i><a href="#"><?php echo esc_html(get_the_author_meta( 'display_name' ,$queried_post->post_author ));?></a></span>
									<span><i class="fa fa-calendar-o"></i><?php echo esc_html(get_the_time('F j, Y', $queried_post->ID ));?></span>
									<span><i class="fa fa-heart-o"></i><a href="#"><?php echo esc_html(get_comments_number( $blog_feature_title ));?></a></span>
								</div>
								<p><?php echo esc_html($queried_post->post_content); ?></p>
							</div>
						</div>						
					</div>						
					<!--/ End Blog Sticky-->
				</div>
				<div class="col-12">
					<div class="blog-slider">
					<?php
                        $blog_catId = esc_attr(get_theme_mod( 'tromas_blog_category_id'));
                        $blog_catLink = get_category_link($blog_catId);
                        $blog_CatName = get_category($blog_catId);
                        $blog_number = get_theme_mod('tromas_blog_number');
                        $args = array(
                        'post_type' => 'post',
                        'posts_per_page' => $blog_number,
                        'post_status' => 'publish',
                        'cat' => $blog_catId,
                       
                    					);

                    $blogloop = new WP_Query($args);
                    
                        while ($blogloop->have_posts()) : 
                        	$blogloop->the_post(); 
                        	?>
					<!-- Single Slider -->
					<div class="single-blog single-slider">
						<div class="blog-post">
							<div class="blog-head">
								<?php if(has_post_thumbnail()): ?>
								<?php 	$blog_img_url = get_the_post_thumbnail_url($post->ID, 'tromas-blog-thumb2');  ?>
									<img src="<?php echo esc_url($blog_img_url); ?>"/>
								<?php endif; ?> 
								<a class="link" href="<?php esc_url(the_permalink()); ?>"><i class="fa fa-paper-plane"></i></a>
							</div>
							<div class="blog-info">
								<h2><a href="<?php esc_url(the_permalink()); ?>"><?php esc_html(the_title()); ?></a></h2>
								<div class="meta">
									<span><i class="fa fa-list"></i><a href="#"><?php tromas_posted_by();?></a></span>
									<span><i class="fa fa-calendar-o"></i> <?php echo get_the_date( 'F j, Y'); ?></span>
									<span><i class="fa fa-heart-o"></i><a href="#"><?php echo esc_html(get_comments_number());?></a></span>
								</div>
								<?php the_content();?>
							</div>
						</div>				
					</div>
					<!--/ End Single Slider -->	
					<?php endwhile;
                        wp_reset_postdata();
                        ?>			
					</div>
				</div>
			</div>						
		</div>
	</div>
</section>
<!--/ End Blog -->	
<?php endif; ?>