<?php if(get_theme_mod('tromas_client_section_enable')): ?>
<!-- Start Clients -->
<section id="clients" class="clients section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$client_title = get_theme_mod('tromas_client_page_title');
						$queried_post = get_post($client_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-12">
				<div class="clients-slider">
						<?php
                        $clients_catId = get_theme_mod( 'tromas_clients_category_id','1' );
                        $client_number = get_theme_mod( 'tromas_client_number','5' );
          			
                        $args = array(
                        'post_type' => 'post',
                        'posts_per_page' => $client_number,
                        'post_status' => 'publish',
                        'paged' => 1,
                        'cat' => $clients_catId,
                           
                        );
                        $clientsloop = new WP_Query($args);
                        if ( $clientsloop->have_posts() ) :
                            while ($clientsloop->have_posts()) : $clientsloop->the_post(); 
                            	$clients_img_url = get_the_post_thumbnail_url($post->ID, 'full');?>
                      <?php if(has_post_thumbnail()): ?>
					<!-- Single Clients -->
					<div class="single-clients">
						<a href="<?php esc_url(the_permalink()); ?>" target="_blank"><?php the_post_thumbnail('tromas-client-thumb'); ?></a>
					</div>
					<?php endif; ?>
					<!--/ End Single Clients -->
					<?php endwhile;
                    wp_reset_postdata();
                    endif;
                    ?>
					
				</div>
			</div>
		</div>
	</div>
</section>
<!--/ End Clients -->
<?php endif; ?>