<?php if(get_theme_mod('tromas_project_section_enable')): ?>
<!-- Start Projects -->
<section id="projects" class="projects section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
					$project_title = get_theme_mod('tromas_project_page_title');
					$queried_post = get_post($project_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-12">
				<!-- project Nav -->
				<div class="project-nav">
					<ul class="cbp-l-filters-work" id="project-menu">
						<?php 
						$project_category_id = get_theme_mod( 'tromas_project_category_id' );
						$args = array('child_of' =>$project_category_id);
						$categories = get_categories( $args );?>
							<li data-filter="*" class="cbp-filter-item active" id="all"><?php esc_html_e('All','tromas');?>(<?php echo absint( tromas_get_cat_postcount( $project_category_id ) );?>)
							</li>  
						<?php
						foreach($categories as $category):?>
							<li data-filter=".<?php echo esc_attr($category->slug);?>" class="cbp-filter-item cbp-click-item"><?php echo esc_html($category->name);?>(<?php echo absint( tromas_get_cat_postcount( $category->term_id ) );?>)</li>
						<?php endforeach;?>
					</ul>  		
				</div>
				<!--/ End project Nav -->
			</div>
		</div>					
		<div class="row">
			<div class="col-12">
				<div id="project-item" class="cbp">
					<?php 
					    $sub_cats = get_categories('parent=' . $project_category_id);
					    if( $sub_cats ) :
					        foreach( $sub_cats as $sub_cat ) :
					            $sub_query = new WP_Query( array(
					                'category__in' => array( $sub_cat->term_id ),
					                'posts_per_page' => 6)
					            );
					            if ( $sub_query->have_posts() ) :
					                while( $sub_query->have_posts() ) : $sub_query->the_post();?>
					           		<div class="cbp-item <?php echo  esc_attr($sub_cat->slug);?>">
									<!-- Single Project -->
									<div class="project-single">
										<div class="project-inner">
											<div class="project-head">
												<?php the_post_thumbnail('tromas-project-thumb');?>
											</div>
											<div class="project-bottom">
												<h4><a href="<?php esc_url(the_permalink());?>"><?php the_title();?></a><span class="category"><?php echo  esc_html($sub_cat->name);?></span></h4>
											</div>
											<div class="button">
												<a data-fancybox="portfolio" href="<?php echo esc_url(get_the_post_thumbnail_url());?>" class="btn"><i class="fa fa-photo"></i></a>
												<a href="<?php esc_url(the_permalink());?>" class="btn"><i class="fa fa-link"></i></a>
											</div>
										</div>
									</div> 
									<!--/ End Single Project -->
									</div>
					        		<?php endwhile;
					            endif;
					        endforeach;
					    endif;
					?>
				</div>
				<!-- Load More -->
				<div id="loadMore" class="cbp-l-loadMore-button all">
					<div class="load-button">
						<a href="<?php echo esc_url(get_category_link( $project_category_id ));?>" class="btn primary" rel="nofollow">
							<?php esc_html_e( 'Load more','tromas' );?>
						</a>
					</div>
				</div>
				<!--/ End Load More -->

				<?php foreach($categories as $category):?>
				<div id="loadMore" class="cbp-l-loadMore-button <?php echo esc_attr($category->slug);?> category-loadmore-button">
					<div class="load-button">
						<a href="<?php echo esc_url(get_category_link( $category->term_id ));?>" class="btn primary" rel="nofollow">
							<?php esc_html_e( 'Load more','tromas' );?>
						</a>
					</div>
				</div>
				<?php endforeach;?>
			</div>
		</div>
	</div>
</section>
<!--/ End Projects -->
<?php endif; ?>