<?php if(get_theme_mod('tromas_our_skill_section_enable')): ?>
<!-- Our Skill -->
<section id="our-skill" class="our-skill section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 col-sm-12 col-xs-12">
					<?php
						$skill_title = get_theme_mod('tromas_skill_title');
						$queried_post = get_post($skill_title);
					?>
				<div class="section-title">
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html( $queried_post->post_content ); ?></p>
				</div>
			</div>
		</div>
		<div class="row"> 
			<div class="col-lg-6 col-12">
				<div class="skill-text">
					<?php
						$skill_work_title = get_theme_mod('tromas_skill_work_title');
						$queried_post = get_post($skill_work_title);
					?>
					<h2><?php echo esc_html($queried_post->post_title); ?></h2>
					<p><?php echo esc_html( $queried_post->post_content ); ?></p>
					<?php if( get_theme_mod('tromas_skill_button_title' ) ):?>
					<a href="<?php echo esc_url( get_theme_mod('tromas_skill_button_url' ) );?>" class="btn primary"><?php echo esc_html(  get_theme_mod('tromas_skill_button_title' ) );?></a>
					<?php endif;?>
				</div>
			</div>
			<div class="col-lg-6 col-12">
				<!-- Single Skill -->
				<?php
				for($k=1;$k<5;$k++):?>
				<div class="single-skill">
					<div class="skill-info">
						<?php if(get_theme_mod('tromas_skill_title_'.$k)):?>
						<h4><?php echo esc_html(get_theme_mod('tromas_skill_title_'.$k)); ?></h4>
						<?php endif;?>
					</div>
					<div class="progress">
						<?php if(get_theme_mod('tromas_skill_percentage_'.$k)):?>
						<div class="progress-bar" role="progressbar" aria-valuenow="<?php echo absint(get_theme_mod('tromas_skill_percentage_'.$k)); ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo absint(get_theme_mod('tromas_skill_percentage_'.$k)); ?>%;">
						<span class="percent"><?php echo absint(get_theme_mod('tromas_skill_percentage_'.$k)); ?>%</span></div>
						<?php endif;?>
					</div>
				</div>
				<?php  endfor;?>
				<!--/ End Single Skill -->
			</div>
		</div>
	</div>
</section>
<!--/ End Our Skill -->
<?php endif; ?>