<?php if(get_theme_mod('tromas_team_section_enable')): ?>
<!-- Start Team -->
<section id="team" class="team section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$team_title = get_theme_mod('tromas_team_page_title');
						$queried_post = get_post($team_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<?php
			$i=1;
			for($k=1;$k<5;$k++){
                  $team[$i] = get_theme_mod('tromas_team_page_'.$k);    
                  $teamposition[$i] = get_theme_mod('tromas_team_position_'.$k);
                  $teamfacebookurl[$i] = get_theme_mod('tromas_team_facebook_url_'.$k);
                  $teamtwitterurl[$i] = get_theme_mod('tromas_team_twitter_url_'.$k);
                  $teamdribbleurl[$i] = get_theme_mod('tromas_team_dribble_url_'.$k);
                  $teaminstagramurl[$i] = get_theme_mod('tromas_team_instagram_url_'.$k);
                  $i=$i+1;
      			}
	           $args = array (
	              'post_type' => 'page',
	              'posts_per_page' => $i,
	              'post__in'      => $team,
	              'orderby'        =>'post__in'
	            );
	          $teamloop = new WP_Query($args); $k=1;
          if ($teamloop->have_posts()) :  while ($teamloop->have_posts()) : $teamloop->the_post(); ?>
			<div class="col-lg-3 col-md-6 col-12">
				<!-- Single Team -->

				<div class="single-team <?php echo esc_attr(number_class_in_team_div($k));?> default">
					<!-- Team Head -->
					<div class="t-head">
						<?php if(has_post_thumbnail()): ?>
						<?php the_post_thumbnail('tromas-team-thumb'); ?> 
						<?php endif; ?>
						<div class="t-hover">
							<ul class="t-social">
								<?php if($teamfacebookurl[$k]):?>
								<li><a href="<?php echo esc_url($teamfacebookurl[$k]); ?>"><i class="fa fa-facebook"></i></a></li>
								<?php endif;?>
								<?php if($teamtwitterurl[$k]):?>
								<li><a href="<?php echo esc_url($teamtwitterurl[$k]); ?>"><i class="fa fa-twitter"></i></a></li>
								<?php endif;?>
								<?php if($teamdribbleurl[$k]):?>
								<li><a href="<?php echo esc_url($teamdribbleurl[$k]); ?>"><i class="fa fa-dribbble"></i></a></li>
								<?php endif;?>
								<?php if($teaminstagramurl[$k]):?>
								<li><a href="<?php echo esc_url($teaminstagramurl[$k]); ?>"><i class="fa fa-instagram"></i></a></li>
								<?php endif;?>>				
							</ul>
						</div>
					</div>
					<!-- Team Bottom -->
					<div class="t-bottom">
						<div class="t-icon">
							<a href="#team<?php echo esc_attr( $k );?>"><i class="fa fa-plus"></i></a>
						</div>
						<h2 class="t-name"><?php the_title(); ?></h2>
						<p class="what"><?php echo esc_html($teamposition[$k]); ?></p>
					</div>
				</div>
				<!-- End Single Team -->
			</div>		
		<?php  $k=$k+1; endwhile;
              wp_reset_postdata();  
            endif; ?>	
		</div>
	  	<?php $teamloop = new WP_Query($args); $k=1;
      	if ($teamloop->have_posts()) :  while ($teamloop->have_posts()) : $teamloop->the_post(); ?>
		<!-- Team Detailes One -->
	
		<div id="team<?php echo esc_attr( $k );?>" class="team-details <?php echo esc_attr(number_class_in_team_div($k));?>">
			<a href="#team<?php echo esc_attr( $k );?>" class="cross"><i class="fa fa-remove" style="    margin-top: 65px;"></i></a>
			<div class="row">
				<div class="col-12">
					<div class="single-team default">
						<div class="t-head">
							<?php if(has_post_thumbnail()): ?>
							<?php the_post_thumbnail('tromas-team-thumb-sidebar'); ?> 
							<?php endif; ?>
							<div class="t-hover">
								<ul class="t-social">
									<?php if($teamfacebookurl[$k]):?>
									<li><a href="<?php echo esc_url($teamfacebookurl[$k]); ?>"><i class="fa fa-facebook"></i></a></li>
									<?php endif;?>
									<?php if($teamtwitterurl[$k]):?>
									<li><a href="<?php echo esc_url($teamtwitterurl[$k]); ?>"><i class="fa fa-twitter"></i></a></li>
									<?php endif;?>
									<?php if($teamdribbleurl[$k]):?>
									<li><a href="<?php echo esc_url($teamdribbleurl[$k]); ?>"><i class="fa fa-dribbble"></i></a></li>
									<?php endif;?>
									<?php if($teaminstagramurl[$k]):?>
									<li><a href="<?php echo esc_url($teaminstagramurl[$k]); ?>"><i class="fa fa-instagram"></i></a></li>
									<?php endif;?>
								</ul>
							</div>
						</div>
					</div>
				</div>	
				<div class="col-12">
					<h2><?php the_title(); ?></h2>
					<?php the_content(); ?>
				<!-- 	<div class="row">		
					<div class="col-12">
						Single Skill
						<div class="single-skill">
							<div class="skill-info">
								<h4 class="title">Creative Idea</h4>
							</div>
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width: 50%;"><span>73%</span></div>
							</div>
						</div>
						/ End Single Skill
					</div>
					<div class="col-12">
						Single Skill
						<div class="single-skill">
							<div class="skill-info">
								<h4 class="title">Web Resource</h4>
							</div>
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuenow="85" aria-valuemin="0" aria-valuemax="100" style="width: 85%;"><span>85%</span></div>
							</div>
						</div>
						/ End Single Skill
					</div>
					<div class="col-12">
						Single Skill
						<div class="single-skill">
							<div class="skill-info">
								<h4 class="title">Success Rate</h4>
							</div>
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuenow="98" aria-valuemin="0" aria-valuemax="100" style="width: 98%;"><span>60%</span></div>
							</div>
						</div>
						/ End Single Skill
					</div>
					<div class="col-12">
						Single Skill
						<div class="single-skill">
							<div class="skill-info">
								<h4 class="title">UI/UX Design</h4>
							</div>
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100" style="width: 90%;"><span>90%</span></div>
							</div>
						</div>
						/ End Single Skill
					</div>
				</div> -->
				</div>
			</div>	
		</div>
		<!--/ End Team Detailes One -->
		<?php  $k=$k+1; endwhile;
          wp_reset_postdata();  
        endif; ?>
	</div>
</section>
<!--/ End Team -->
<?php endif;?>