<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tromas
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<div class="col-12">
	<!-- Single Post -->
	<div class="single-blog slider">
		<div class="blog-post">
			<div class="blog-head">
				<div class="blog-slide">
					<div class="single-slide">
						<?php the_post_thumbnail('tromas-blog-thumb2'); ?>
					</div>
				</div>
			</div>
			<div class="blog-info">
			<?php
				if ( is_singular() ) :
					the_title( '<h2 class="entry-title">', '</h2>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;?>
				<div class="meta">
					<span><i class="fa fa-list"></i><a href="#"><?php tromas_posted_by();?></a></span>
					<span><i class="fa fa-calendar-o"></i><?php the_date( 'j F, Y');?></span>
					<span><i class="fa fa-heart-o"></i><a href="#"><?php echo esc_html(get_comments_number());?></a></span>
				</div>
				<?php the_excerpt();?>
			</div>
		</div>				
	</div>
	<!--/ End Single Post -->
</div>
</article><!-- #post-<?php the_ID(); ?> -->

