<?php if(get_theme_mod('tromas_faq_section_enable')): ?>	
<!-- Start Faqs -->
<section id="faq" class="faq section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$faq_title = get_theme_mod('tromas_faq_page_title');
						$queried_post = get_post($faq_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<?php if( get_theme_mod( 'tromas_faq_category_id') ):?>
			<div class="col-lg-7 col-12">
				<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
					<?php  
						$faqcatId = get_theme_mod( 'tromas_faq_category_id');
                        $faqnumber = get_theme_mod( 'tromas_faq_number');
                      $args = array(
                      		'post_type'         =>  'post',
				        	'cat'		 		=> absint( $faqcatId ),
				    		'posts_per_page'  	=> $faqnumber,
				    		'post_status'       =>  'publish'
				        );
        				$faqloop = new WP_Query($args);
                        $i=1;
                         if( $faqloop->have_posts() ) : 
                         while( $faqloop->have_posts() ) : $faqloop->the_post(); ?>
							<div class="panel panel-default <?php if($i ==1){ echo 'active';}?>">
								<!-- Single Faq -->
								<div class="faq-heading"  id="FaqTitle<?php echo esc_attr( $i );?>">
								  <h4 class="faq-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#faq<?php echo esc_attr( $i );?>"><?php the_title(); ?></a>
								  </h4>
								</div>
								<div id="faq<?php echo esc_attr( $i );?>" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="FaqTitle<?php echo esc_attr( $i );?>">
								  <div class="faq-body"><?php the_content(); ?></div>
								</div>
								<!--/ End Single Faq -->
							</div>
					<?php $i=$i+1;
						endwhile;
                    	wp_reset_postdata();
                    endif;?>
				</div>
			</div>
			<?php endif;?>
			<div class="col-lg-5">
				<div class="faq-image">
					<?php echo get_the_post_thumbnail($faq_title,'tromas-faq-thumb');?>
				</div>
			</div>
		</div>
	</div>
</section>
<!--/ End Faqs -->
<?php endif; ?>