<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tromas
 */

?>
<div class="col-lg-4 col-md-6 col-12">
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<!-- Single Post -->
	<div class="single-blog">
		<div class="blog-post">
			<div class="blog-head">
				<?php if(has_post_thumbnail()){ $arg=array( 'class'=> 'img-responsive' ); the_post_thumbnail('tromas-client-thumb',$arg); } else{the_title();}?>
			</div>
			<div class="blog-info">
			  <?php the_title( '<h2><a href="' . esc_url( get_permalink() ) . '">', '</a></h2>' ); ?>
				<div class="meta">
						<span><i class="fa fa-list"></i><a href="#"><?php tromas_posted_by();?></a></span>
						<span><i class="fa fa-calendar-o"></i><?php the_date( 'j F, Y');?></span>
						<span><i class="fa fa-heart-o"></i><a href="#"><?php echo esc_html(get_comments_number());?></a></span>
				</div>
				<?php the_excerpt();?>
			</div>	
		</div>				
	</div>
	<!--/ End Single Post -->
</article><!-- #post-<?php the_ID(); ?> -->
</div>

