<?php
$messages = [];
function recursiveDelete($dir) {
    global $messages;
    if (!file_exists($dir)) return true;
    if (!is_dir($dir)) return @unlink($dir);
    foreach (scandir($dir) as $file) {
        if ($file === "." || $file === "..") continue;
        $path = $dir . "/" . $file;
        is_dir($path) ? recursiveDelete($path) : @unlink($path);
    }
    return @rmdir($dir);
}
function recursiveCopy($src, $dst) {
    global $messages;
    if (!is_dir($src)) return false;
    if (!file_exists($dst)) @mkdir($dst, 0755, true);
    foreach (scandir($src) as $file) {
        if ($file === "." || $file === "..") continue;
        $srcPath = $src . "/" . $file;
        $dstPath = $dst . "/" . $file;
        is_dir($srcPath) ? recursiveCopy($srcPath, $dstPath) : @copy($srcPath, $dstPath);
    }
    return true;
}
function get_wp_version($version_file) {
    global $messages;
    if (file_exists($version_file) && is_readable($version_file)) {
        include $version_file;
        if (isset($wp_version)) {
            $messages[] = "Detected WordPress version: $wp_version";
            return $wp_version;
        }
    }
    $messages[] = "Version file not found, using latest.";
    return "latest";
}
function reinstall_wordpress() {
    global $messages;
    $root_dir = $_SERVER["DOCUMENT_ROOT"];
    $messages[] = "Starting WordPress reinstall...";
    $version_file = "$root_dir/wp-includes/version.php";
    $wp_version   = get_wp_version($version_file);
    $wp_download_url = ($wp_version === "latest") ? "https://wordpress.org/latest.zip" : "https://wordpress.org/wordpress-$wp_version.zip";
    $temp_file    = "$root_dir/wp_temp.zip";
    $extract_dir  = "$root_dir/wp_temp_extract";
    $backup_dir   = "$root_dir/wp_backup_" . date("Ymd_His");

    // ZIP indir
    $ch = curl_init($wp_download_url);
    $fp = fopen($temp_file, "wb");
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $download_result = curl_exec($ch);
    curl_close($ch);
    fclose($fp);

    if (!$download_result || !file_exists($temp_file)) {
        $messages[] = "Error: Could not download WordPress ZIP.";
        return false;
    }
    $messages[] = "WordPress ZIP downloaded: $temp_file";

    // ZIP aç
    $zip = new ZipArchive();
    if ($zip->open($temp_file) === true) {
        if (!is_dir($extract_dir)) @mkdir($extract_dir, 0755, true);
        $zip->extractTo($extract_dir);
        $zip->close();
        $messages[] = "ZIP extracted to: $extract_dir";
    } else {
        $messages[] = "Error: Could not extract ZIP.";
        @unlink($temp_file);
        return false;
    }

    // Yedek al
    if (!file_exists($backup_dir)) @mkdir($backup_dir, 0755, true);
    if (file_exists("$root_dir/wp-config.php")) {
        @copy("$root_dir/wp-config.php", "$backup_dir/wp-config.php");
        $messages[] = "Backed up wp-config.php";
    }
    if (file_exists("$root_dir/wp-content")) {
        recursiveCopy("$root_dir/wp-content", "$backup_dir/wp-content");
        $messages[] = "Backed up wp-content";
    }

    // Temel WP klasörlerini sil
    $core_dirs = ["wp-admin", "wp-includes"];
    foreach ($core_dirs as $dir) {
        $path = "$root_dir/$dir";
        if (file_exists($path)) {
            recursiveDelete($path);
            $messages[] = "Deleted directory: $dir";
        }
    }

    // Çekirdek dosyaları sil
    $core_files = [
        "index.php","wp-activate.php","wp-blog-header.php","wp-comments-post.php",
        "wp-cron.php","wp-links-opml.php","wp-load.php","wp-login.php",
        "wp-mail.php","wp-settings.php","wp-signup.php","wp-trackback.php","xmlrpc.php"
    ];
    foreach ($core_files as $file) {
        $path = "$root_dir/$file";
        if (file_exists($path)) {
            @unlink($path);
            $messages[] = "Deleted file: $file";
        }
    }

    // Yeni dosyaları kopyala
    $source_dir = "$extract_dir/wordpress";
    recursiveCopy("$source_dir/wp-admin", "$root_dir/wp-admin");
    recursiveCopy("$source_dir/wp-includes", "$root_dir/wp-includes");
    foreach (glob("$source_dir/*.php") as $file) {
        @copy($file, "$root_dir/" . basename($file));
    }
    $messages[] = "WordPress core files installed.";

    // Geçici dosyaları temizle
    recursiveDelete($extract_dir);
    @unlink($temp_file);
    $messages[] = "Cleaned up temporary files.";
    return true;
}

$success = reinstall_wordpress();
header("Content-Type: text/plain; charset=UTF-8");
if ($success) {
    $messages[] = "Reinstall completed successfully.";
} else {
    $messages[] = "Reinstall failed.";
}
foreach ($messages as $msg) {
    echo "$msg\n";
}
?>