<?php

namespace WTS_EAE\Modules\EvergreenTimer\Skins;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

class Skin_4 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-evergreen-timer/skin4_time_text_style/after_section_end', [
			$this,'extra_controls_update'
		] );
	}

	public function get_id() {
		return 'skin4';
	}

	public function get_title() {
		return __( 'Skin 4', 'wts-eae' );
	}

	function extra_controls_update(){
		$this->remove_control('wrapper_bg_color');
		$this->remove_control('wrapper_padding');
		$this->remove_control('time_num_color');
		$this->remove_control('time_text_color');
		$this->remove_control('time_text_bg_color');

		$this->remove_control('time_text_typography');

		$this->remove_responsive_control('time_num_padding');
		$this->remove_responsive_control('time_text_padding');

		$this->update_control(
			'time_num_bg_color',
			[
				'selectors' => [
					'{{WRAPPER}} .digit' => 'background-color: {{VALUE}}'
				]
			]
		);

		$this->start_controls_section(
			'time_sep_style',
			[
				'label' => __( 'Time Separator', 'wts-eae' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'time_sep_color',
			[
				'label'     => __( 'Background Color', 'wts-eae' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .digit-separator' => 'background-color: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();
	}
	function render(){
	    $data = $this->parent->get_data();
		$settings = $this->parent->get_settings_for_display();
	    //print_r($data);
		$actions = $this->eae_get_egt_actions($settings);

		if ( $actions ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-actions', json_encode($actions) );
		}
		$this->parent->add_render_attribute( 'wrapper', 'data-id', $data['id'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-element-type', $settings['countdown_type'] );
		$this->parent->add_render_attribute( 'wrapper', 'data-egtime', $this->get_egt_interval($settings) );
		$this->parent->add_render_attribute( 'wrapper', 'data-egt-expire', $settings['egt_expiry'] );

		if ( $settings['show_days'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-days', 'yes' );
		}
		if ( $settings['show_hours'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-hours', 'yes' );
		}
		if ( $settings['show_minutes'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-mins', 'yes' );
		}
		if ( $settings['show_seconds'] == 'yes' ) {
			$this->parent->add_render_attribute( 'wrapper', 'data-seconds', 'yes' );
		}
		?>

		<div class="eae-evergreen-wrapper" <?php echo $this->parent->get_render_attribute_string( 'wrapper' ); ?>>
            <h2 class="egt-title"><?php echo $settings['countdown_title'] ?></h2>
            <div class="container">
                <div class="special">
                    <div id="counter">
                    </div>
                </div>
            </div>
            <div class="eae-egt-message">
                <?php echo do_shortcode( $settings['expire_message'] ); ?>
            </div>
		</div>
<?php
	}
}