<?php

namespace WTS_EAE\Modules\Timeline\Skins;

use Elementor\Widget_Base;


class Skin_3 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-timeline/skin3_icon_global_style/after_section_end', [ $this, 'extra_control' ] );
		add_action( 'elementor/element/eae-timeline/skin3_section_global_icon/after_section_end', [ $this, 'update_icon_control' ] );
	}

	public function get_id() {
		return 'skin3';
	}

	public function get_title() {
		return __( 'Skin 3', 'wts-eae' );
	}

	function update_icon_control(){
		$this->update_control(
			'global_icon_shape',
			[
				'default' => 'square',
			]
		);
	}
	function extra_control() {

		$this->update_control(
			'item_icon_icon_primary_color',
			[
				'default' => '#6ec1e4',
			]
		);
		$this->update_control(
			'item_icon_icon_secondary_color',
			[
				'default' => '#ffffff',
			]
		);
		$this->update_control(
			'item_icon_icon_focus_primary_color',
			[
				'default' => '#4054b2',
			]
		);
		$this->update_control(
			'item_icon_icon_focus_secondary_color',
			[
				'default' => '#ffffff',
			]
		);
		$this->update_control(
			'item_icon_icon_border_radius',
			[
				'default' => [
					'top'    => 7,
					'right'  => 7,
					'bottom' => 7,
					'left'   => 7,
				],
			]
		);
		$this->update_control(
			'timeline_align',
			[
				'default' => 'left',
			]
		);
		$this->update_control(
			'content_align',
			[
				'default' => 'left',
			]
		);
		$this->update_control(
			'content_padding',
			[
				'default' => [
					'top'    => 0,
					'right'  => 0,
					'bottom' => 0,
					'left'   => 0,
				],
			]
		);
		$this->update_control(
			'line_bg_color',
			[
				'default' => '#4054b2',
			]
		);
		$this->update_control(
			'progress_color',
			[
				'default' => '#d8d8d8',
			]
		);
		$this->update_control(
			'line_thickness',
			[
				'default' => [
					'size' => 5,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_size',
			[
				'default' => [
					'size' => 25,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_padding',
			[
				'default' => [
					'size' => 10,
				],
			]
		);
		$this->update_control(
			'arrow_align',
			[
				'default' => 'top',
			]
		);
	}
	public function register_items_control( Widget_Base $widget ) {
		$this->parent = $widget;
		//$this->bpel_timeline_content_section( $widget );
	}
	public function register_style_controls() {
		parent::register_style_controls(); // TODO: Change the autogenerated stub
		$this->eae_timeline_style_section();

	}
	public function render() {
		$this->common_render();
	}
}
