<?php
if( !class_exists('Tromas_Tab_Latest_Popular_Widget')){
	class Tromas_Tab_Latest_Popular_Widget extends WP_Widget{
	//setup the widget name, description, etc....
	public function __construct(){
		$widget_ops=array(
			'classname'	=>	'tromas-latest-popular-post-widget',
			'description'	=>	'Custom Tab Latest & Popular Post Widget',
		);

		parent::__construct( 'tromas_latest_popular_post','Tab Latest & Popular Post Widget', $widget_ops );
	}

	public function widget( $args, $instance){?>
		<div class="single-sidebar post-tab">
			<!-- Post Menu -->
			<ul class="nav nav-tabs" id="myTab" role="tablist">
				<li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#latest" role="tab"><?php esc_html_e( 'Latest Posts', 'tromas' );?> </a></li>
				<li role="presentation"><a class="nav-link" data-toggle="tab" href="#popular" role="tab"><?php esc_html_e( 'Popular Posts', 'tromas' );?></a></li>
			</ul>
		<!--/ End Post Menu -->
			<div class="tab-content">
				<div class="tab-pane fade show active" id="latest" role="tabpanel">
						<!-- Single Post -->
						<?php tromas_tabs_latest_posts(5);?>
						<!--/ End Single Post -->
				</div>
				<div class="tab-pane fade" id="popular" role="tabpanel">
					<!-- Single Post -->
						<?php tromas_tabs_popular_posts(5);?>
					<!--/ End Single Post -->
				</div>
			</div>
		</div><!--/ End Post Tab -->
	<?php	}
	}
}

