<?php if(get_theme_mod('tromas_contact_section_enable')): ?>
<!-- Start Contact -->
<section id="contact-us" class="contact-us section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$contact_title = get_theme_mod('tromas_contact_page_title');
						$queried_post = get_post($contact_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<!-- Contact Form -->
			<div class="col-lg-8 col-md-6 col-12">
				<form class="form" method="post">
					<div class="row">
						<?php if (get_theme_mod('tromas_contact_form_code')):
					  		echo do_shortcode(get_theme_mod('tromas_contact_form_code')); 
						endif; ?>		
					</div>
				</form>
			</div>
			<!--/ End Contact Form -->
			<!-- Contact Address -->
			<?php if(get_theme_mod('tromas_touch_section_enable')): ?>
			<div class="col-lg-4 col-md-6 col-12">
				<div class="contact-address">
					<div class="contact">
						<?php
						$touch_title = get_theme_mod('tromas_touch_page_title');
						$queried_post = get_post($touch_title);
						?>
						<h2><?php echo esc_html($queried_post->post_title); ?></h2>
						<p><?php echo esc_html($queried_post->post_content); ?></p>
						<?php wp_reset_postdata(); ?>
						<!-- Single Address -->
						<?php for($i=1;$i<=3;$i++):?>
						<div class="single-address">
							<span><i class="fa <?php echo esc_attr( get_theme_mod( 'tromas_touch_icon_'.$i ) )?>"></i><?php echo esc_html( get_theme_mod( 'tromas_touch_'.$i ) )?></span>
							<p><?php echo esc_html( get_theme_mod( 'tromas_touch_field_'.$i ) )?></p>
						</div>
						<?php endfor;?>
						<!--/ End Single Address -->
					</div>
				</div>
			</div>
			<!--/ End Contact Address -->
			<?php endif;?>
		</div>
	</div>
</section>
<!--/ End Contact -->
<?php endif;?>
<!-- Map Section -->
<div class="map-section">
	<div id="myMap">
	<?php if ( is_active_sidebar( 'google-map' ) ) { ?>
		<?php dynamic_sidebar( 'google-map' );?>
	<?php } ?>
	</div>
</div>
<!--/ End Map Section -->

