<?php if(get_theme_mod('tromas_team_section_enable')): ?>
<!-- Start Team -->
<section id="team" class="team section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<?php
						$team_title = get_theme_mod('tromas_team_page_title');
						$queried_post = get_post($team_title);
					?>
					<h1><?php echo esc_html($queried_post->post_title); ?></h1>
					<p><?php echo esc_html($queried_post->post_content); ?></p>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<div class="row">
			<?php
			$i=1;
			for($i=1;$i<5;$i++){
                  $team[$i] = get_theme_mod('tromas_team_page_'.$i);    
                  $teamposition[$i] = get_theme_mod('tromas_team_position_'.$i);
      			}
	           $args = array (
	              'post_type' => 'page',
	              'posts_per_page' => $i,
	              'post__in'      => $team,
	              'orderby'        =>'post__in'
	            );
	          $teamloop = new WP_Query($args); $k=1;
          if ($teamloop->have_posts()) :  while ($teamloop->have_posts()) : $teamloop->the_post(); ?>
			<div class="col-lg-3 col-md-6 col-12">
				<!-- Single Team -->
				<div class="single-team default" id="team-<?php echo absint( $k );?>">
					<!-- Team Head -->
					<div class="t-head">
						<?php if(has_post_thumbnail()): ?>
						<?php the_post_thumbnail('tromas-team-thumb'); ?> 
						<?php endif; ?>
					</div>
					<!-- Team Bottom -->
					<div class="t-bottom">
						<div class="t-icon">
							<a href="#team<?php echo absint( $k );?>"><i class="fa fa-plus"></i></a>
						</div>
						<h2 class="t-name"><?php the_title(); ?></h2>
						<p class="what"><?php echo esc_html($teamposition[$k]); ?></p>
					</div>
				</div>
				<!-- End Single Team -->
			</div>		
		<?php  $k=$k+1; endwhile;
              wp_reset_postdata();  
            endif; ?>	
		</div>
	  	<?php $teamloop = new WP_Query($args); $k=1;
      	if ($teamloop->have_posts()) :  while ($teamloop->have_posts()) : $teamloop->the_post(); ?>
		<!-- Team Detailes One -->
		<div id="team<?php echo absint( $k );?>" class="team-details team-<?php echo absint( $k );?>">
			<a href="#team<?php echo absint( $k );?>" class="cross" data-target="team-<?php echo absint( $k );?>"><i class="fa fa-remove" style="margin-top: 65px;"></i></a>
			<div class="row">
				<div class="col-12">
					<div class="single-team default">
						<div class="t-head">
							<?php if(has_post_thumbnail()): ?>
							<?php the_post_thumbnail('tromas-team-thumb-sidebar'); ?> 
							<?php endif; ?>
						</div>
					</div>
				</div>	
				<div class="col-12">
					<h2><?php the_title(); ?></h2>
					<?php the_content(); ?>
				</div>
			</div>	
		</div>
		<!--/ End Team Detailes One -->
		<?php  $k=$k+1; endwhile;
          wp_reset_postdata();  
        endif; ?>
	</div>
</section>
<!--/ End Team -->
<?php endif;?>