<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tromas
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<!-- Single Post -->
	<div class="single-blog">
		<div class="blog-post">
			<div class="blog-head">
				<?php the_post_thumbnail('post-thumbnail');?>
			</div>
			<div class="blog-info">
			<?php
					the_title( '<h2 class="entry-title">', '</h2>' ); ?>
				<div class="meta">
					<span><i class="fa fa-list"></i><a href="<?php the_permalink(); ?>"><?php tromas_posted_by();?></a></span>
					<span><i class="fa fa-calendar-o"></i><?php the_date( 'j F, Y');?></span>
					<span><i class="fa fa-heart-o"></i><a href="<?php the_permalink(); ?>"><?php echo esc_html(get_comments_number());?></a></span>
				</div>
				<?php the_content();?>
			</div>
		</div>				
	</div>
	<!--/ End Single Post -->
</article><!-- #post-<?php the_ID(); ?> -->

